package ru.foodtechlab.lib.auth.integration.core.authorizationSession;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

import java.util.Optional;

public interface AuthorizationSessionServiceFacade {

    SearchResult<AuthorizationSessionResponse> find(SearchAuthorizationSessionsWithFiltersRequest searchFilters);

    Optional<AuthorizationSessionResponse> findById(String id);

    void disable(String id);

    void disableByPhone(DisableByPhoneRequest command);

    void disableByEmail(DisableByEmailRequest command);

    void disableByIp(DisableByIpRequest command);

    void disableByDeviceId(DisableByDeviceIdRequest command);

    void disableByUsername(DisableByUsernameRequest command);
}
