package ru.foodtechlab.lib.auth.integration.core.authorizartion.mappers;

import com.rcore.domain.security.model.CredentialDetails;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;

public class CredentialDetailsMapper {

    public static CredentialDetails map(CredentialResponse credentialDTO) {
        return new CredentialDetails(
                credentialDTO.getId(),
                Optional.ofNullable(credentialDTO.getRoles())
                        .map(roles -> roles.stream()
                                .map(r -> new CredentialDetails.Role(r.getRole().getId(), r.getRole().getCode()))
                                .collect(Collectors.toList()))
                        .orElse(new ArrayList<>())
        );
    }

}
