package ru.foodtechlab.lib.auth.integration.core;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ConfigurationProperties(prefix = "foodtechlab")
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class FoodtechlabGroupProperties {

    private List<Group> groups;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Group {
        private String name;
        private String username;
        private String password;
        private Service authService;
        private List<Service> services;
    }

    @AllArgsConstructor
    @NoArgsConstructor
    @Getter
    @Setter
    public static class Service {
        private String url;

        public String getUrl() {
            if (!url.startsWith("http"))
                return "http://" + url;

            return url;
        }
    }

    public Optional<Group> findGroupByService(String serviceUrl) {
        var url = serviceUrl.startsWith("http") ? serviceUrl : "http://" + serviceUrl;

        Optional<Group> targetGroup = Optional.empty();
        targetGroup = groups.stream().filter(g -> g.getAuthService().getUrl().equals(url)).findFirst();

        if (targetGroup.isEmpty())
            return groups.stream()
                    .filter(g -> g.getServices()
                            .stream().map(Service::getUrl).collect(Collectors.toList()).contains(url))
                    .findFirst();
        else
            return targetGroup;
    }

}
