package ru.foodtechlab.lib.auth.integration.core.token.accessToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;

import java.util.Optional;

public interface AccessTokenServiceFacade {

    SearchResult<AccessTokenResponse> find(AccessTokenFiltersRequest request);

    Optional<AccessTokenResponse> findById(String id);

    AccessTokenResponse decode(DecodeTokenRequest request);

    EncodedTokenResponse encode(String id);

    void expireByStatus(String id);

    void deactivateByCredentialId(String credentialId);

    void expireByTime(String id);
}
