package ru.foodtechlab.lib.auth.integration.core.role;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.CreateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.SearchRoleWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.UpdateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.responses.RoleResponse;

import java.util.Optional;

public interface RoleServiceFacade {

    SearchResult<RoleResponse> find(SearchRoleWithFiltersRequest request);

    Optional<RoleResponse> findById(String id);

    Optional<RoleResponse> findByCode(String code);

    RoleResponse create(CreateRoleRequest createRoleRequest);

    RoleResponse update(String id, UpdateRoleRequest request);

    void delete(String id);

    RoleResponse generateDefaultRole();

    RoleResponse generateManagerRole();

}
