package ru.foodtechlab.lib.auth.integration.core.credential;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

import java.util.Optional;

public interface CredentialServiceFacade {

    CredentialResponse init(InitCredentialRequest createCredentialRequest);

    Boolean checkInitAvailable();

    SearchResult<CredentialResponse> find(FindCredentialWithFiltersRequest request);

    Optional<CredentialResponse> findByPhoneNumber(String phoneNumber);

    Optional<CredentialResponse> findByEmail(String email);

    Optional<CredentialResponse> findById(String id);

    Optional<CredentialResponse> findByName(String name);

    CredentialResponse create(CreateCredentialRequest createCredentialRequest);

    CredentialResponse update(String id, UpdateCredentialRequest updateCredentialRequest);

    CredentialResponse changeStatus(String id);

    void delete(String id);

    CredentialResponse changePassword(String id, ChangeCredentialPasswordRequest request);

    CredentialResponse generateDefaultCredential(String password);

}
