package ru.foodtechlab.lib.auth.integration.core;

import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthorizationServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.RefreshTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.UsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.TokenPairDTO;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

@Service
public class AccessTokenServiceImpl implements AccessTokenService {

    private static final String ROLE_CODE = "MICROSERVICE";
    private static final String PLATFORM = "spring-boot-app";
    private final String username;
    private final String password;
    private final String serviceName;

    private final AuthorizationServiceFacade authorizationServiceFacade;
    private TokenPairDTO tokenPair = new TokenPairDTO();

    public AccessTokenServiceImpl(
            @Value("${foodtechlab.security.username:t}") String username,
            @Value("${foodtechlab.security.password:t}") String password,
            @Value("${spring.application.name}") String serviceName,
            AuthorizationServiceFacade authorizationServiceFacade
    ) {
        this.username = username;
        this.password = password;
        this.serviceName = serviceName;
        this.authorizationServiceFacade = authorizationServiceFacade;
    }

    @Override
    public String getAccessToken(String requestPath) {

        if (tokenPair.getAccessToken() == null) {
            if (tokenPair.getRefreshToken() != null) {
                tokenPair = refreshToken();
            } else {
                tokenPair = login();
            }
        }

        return tokenPair.getAccessToken();
    }

    //fcheck.card-service.ru fcheck.auth-service
    private TokenPairDTO refreshToken() {
        try {
            var newPair = authorizationServiceFacade.refreshToken(RefreshTokenRequest.of(tokenPair.getRefreshToken()));
            return TokenPairDTO.of(newPair.getAccessToken(), newPair.getRefreshToken());
        } catch (HttpCommunicationException e) {
            return login();
        }
    }

    private TokenPairDTO login() {
        var newPair = authorizationServiceFacade.usernameAuthorization(UsernameAuthorizationRequest.builder()
                .username(username)
                .password(password)
                .roleCode(ROLE_CODE)
                .ip("127.0.0.1")
                .deviceId(serviceName)
                .applicationDetails(AuthorizationSessionResponse.ApplicationDetails.builder()
                        .name(serviceName)
                        .platform(PLATFORM)
                        .build())
                .isRegistrationAllowed(false)
                .build());
        return TokenPairDTO.of(newPair.getAccessToken(), newPair.getRefreshToken());
    }

    @Override
    public void clearToken(String requestUrl) {
        tokenPair.setAccessToken(null);
    }
}
