package ru.foodtechlab.lib.auth.integration.core.token.refreshToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;

import java.util.Optional;

public interface RefreshTokenServiceFacade {

    SearchResult<RefreshTokenResponse> find(RefreshTokenFiltersRequest request);

    Optional<RefreshTokenResponse> findById(String id);

    RefreshTokenResponse decode(DecodeTokenRequest request);

    EncodedTokenResponse encode(String id);

    void expireByStatus(String id);

    void expireByTime(String id);
}
