package ru.foodtechlab.lib.auth.integration.core.roleAccess;

import com.rcore.domain.commons.port.dto.SearchResult;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CreateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.FindRoleAccessWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.UpdateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;

import java.util.Optional;

public interface RoleAccessServiceFacade {
    SearchResult<RoleAccessResponse> find(FindRoleAccessWithFiltersRequest command);

    Optional<RoleAccessResponse> findById(String id);

    RoleAccessResponse create(CreateRoleAccessRequest command);

    RoleAccessResponse update(String id, UpdateRoleAccessRequest command);

    void delete(String id);

    RoleAccessResponse generateGodMode();
}
