package ru.foodtechlab.lib.auth.integration.core.authorizartion.impl;


import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.domain.security.port.CredentialIdentityService;
import lombok.RequiredArgsConstructor;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthCredentialServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.mappers.CredentialDetailsMapper;

@RequiredArgsConstructor
public class CredentialIdentityServiceViaAuthService implements CredentialIdentityService {

    private final AuthCredentialServiceFacade authCredentialServiceFacade;

    @Override
    public CredentialDetails getCredentialByToken(String s) {
        return CredentialDetailsMapper.map(authCredentialServiceFacade.getCredentialByAccessToken(s));
    }
}
