package ru.foodtechlab.lib.auth.integration.core.authorizartion;


import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;

public interface AuthorizationServiceFacade {

    ConfirmationCodeTimerResponse singUpByPhoneNumber(SignUpByPhoneNumberRequest command);

    ConfirmationCodeTimerResponse singUpByEmail(SignUpByEmailRequest command);

    BasicAuthorizationResponse signUpConfirmationByPhoneNumber(SignUpConfirmationByPhoneNumberRequest command);

    BasicAuthorizationResponse signUpConfirmationByEmail(SignUpConfirmationByEmailRequest command);

    BasicAuthorizationResponse usernameAuthorization(UsernameAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions;

    BasicAuthorizationResponse emailAuthorization(EmailAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions;

    BasicAuthorizationResponse phoneNumberAuthorization(PhoneNumberAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions;

    BasicAuthorizationResponse refreshToken(RefreshTokenRequest command) throws AuthServiceException;

    void logout(LogoutRequest command) throws AuthServiceException;
}
