/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.proxy;

import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.Registration;
import io.fluxzero.javaclient.configuration.ApplicationProperties;
import io.fluxzero.javaclient.configuration.client.Client;
import io.fluxzero.javaclient.configuration.client.WebSocketClient;
import io.fluxzero.proxy.ForwardProxyConsumer;
import io.fluxzero.proxy.ProxyRequestHandler;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.util.Headers;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer
implements Registration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);
    private final ProxyRequestHandler proxyHandler;
    private final Undertow server;
    private final int port;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Uncaught error", e));
        int port = ApplicationProperties.getIntegerProperty((String)"PROXY_PORT", (Integer)8080);
        Client client = Optional.ofNullable(ApplicationProperties.getProperty((String)"FLUX_BASE_URL", (String)ApplicationProperties.getProperty((String)"FLUX_URL"))).map(url -> WebSocketClient.newInstance((WebSocketClient.ClientConfig)WebSocketClient.ClientConfig.builder().name("$proxy").serviceBaseUrl(url).projectId(ApplicationProperties.getProperty((String)"PROJECT_ID")).build())).orElseThrow(() -> new IllegalStateException("FLUX_BASE_URL environment variable is not set"));
        Registration registration = ProxyServer.start(port, new ProxyRequestHandler(client)).merge(ForwardProxyConsumer.start(client));
        log.info("Fluxzero proxy server running on port {}", (Object)port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping Fluxzero proxy server");
            registration.cancel();
        }, ObjectUtils.newThreadName((String)"ProxyServer-shutdown")));
    }

    public static ProxyServer start(ProxyRequestHandler proxyHandler) {
        return ProxyServer.start(0, proxyHandler);
    }

    public static ProxyServer start(int port, ProxyRequestHandler proxyHandler) {
        int n;
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler((HttpHandler)Handlers.path().addPrefixPath("/", (HttpHandler)proxyHandler).addExactPath(ApplicationProperties.getProperty((String)"PROXY_HEALTH_ENDPOINT", (String)"/proxy/health"), exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            exchange.getResponseSender().send("Healthy");
        })).build();
        server.start();
        SocketAddress socketAddress = ((Undertow.ListenerInfo)server.getListenerInfo().getFirst()).getAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress a = (InetSocketAddress)socketAddress;
            n = a.getPort();
        } else {
            n = port;
        }
        port = n;
        return new ProxyServer(proxyHandler, server, port);
    }

    public void cancel() {
        this.proxyHandler.close();
        this.server.stop();
    }

    @ConstructorProperties(value={"proxyHandler", "server", "port"})
    @Generated
    protected ProxyServer(ProxyRequestHandler proxyHandler, Undertow server, int port) {
        this.proxyHandler = proxyHandler;
        this.server = server;
        this.port = port;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

