/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.proxy;

import io.fluxzero.common.Guarantee;
import io.fluxzero.common.MessageType;
import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.api.Metadata;
import io.fluxzero.common.api.SerializedMessage;
import io.fluxzero.javaclient.common.serialization.Serializer;
import io.fluxzero.javaclient.configuration.client.Client;
import io.fluxzero.javaclient.publishing.DefaultRequestHandler;
import io.fluxzero.javaclient.publishing.RequestHandler;
import io.fluxzero.javaclient.publishing.client.GatewayClient;
import io.fluxzero.javaclient.web.WebRequest;
import io.fluxzero.javaclient.web.WebResponse;
import io.fluxzero.javaclient.web.WebUtils;
import io.fluxzero.proxy.ProxySerializer;
import io.fluxzero.proxy.WebsocketEndpoint;
import io.fluxzero.proxy.WebsocketFilter;
import io.undertow.Undertow;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import jakarta.servlet.DispatcherType;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;

public class ProxyRequestHandler
implements HttpHandler,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyRequestHandler.class);
    private final ProxySerializer serializer = new ProxySerializer();
    private final GatewayClient requestGateway;
    private final RequestHandler requestHandler;
    private final WebsocketEndpoint websocketEndpoint;
    private final HttpHandler websocketHandler;
    private final AtomicBoolean closed = new AtomicBoolean();

    public ProxyRequestHandler(Client client) {
        this.requestGateway = client.getGatewayClient(MessageType.WEBREQUEST);
        this.requestHandler = new DefaultRequestHandler(client, MessageType.WEBRESPONSE, Duration.ofSeconds(200L), String.format("%s_%s", client.name(), "$proxy-request-handler"));
        this.websocketEndpoint = new WebsocketEndpoint(client);
        this.websocketHandler = this.createWebsocketHandler();
    }

    public void handleRequest(HttpServerExchange exchange) {
        if (this.closed.get()) {
            throw new IllegalStateException("Request handler has been shut down and is not accepting new requests");
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        exchange.getRequestReceiver().receiveFullBytes((se, payload) -> se.dispatch(() -> {
            try {
                this.sendWebRequest(se, this.createWebRequest(se, payload));
            }
            catch (Throwable e) {
                log.error("Failed to create request", e);
                this.sendServerError(se);
            }
        }), (se, error) -> se.dispatch(() -> {
            log.error("Failed to read incoming message", (Throwable)error);
            this.sendServerError(se);
        }));
    }

    protected WebRequest createWebRequest(HttpServerExchange se, byte[] payload) {
        WebRequest.Builder builder = WebRequest.builder().url(se.getRelativePath() + (String)(se.getQueryString().isBlank() ? "" : "?" + se.getQueryString())).method(se.getRequestMethod().toString()).payload((Object)payload).acceptGzipEncoding(false);
        se.getRequestHeaders().forEach(header -> header.forEach(value -> builder.header(header.getHeaderName().toString(), value)));
        return this.tryUpgrade(builder.build(), se);
    }

    protected WebRequest tryUpgrade(WebRequest webRequest, HttpServerExchange se) {
        if ("GET".equals(webRequest.getMethod()) && "Upgrade".equalsIgnoreCase(webRequest.getHeader("Connection")) && "websocket".equalsIgnoreCase(webRequest.getHeader("Upgrade"))) {
            WebRequest.Builder requestBuilder = webRequest.toBuilder();
            List<String> protocols = ProxyRequestHandler.getWebsocketProtocols(webRequest.getHeaders("Sec-WebSocket-Protocol"));
            if (!protocols.isEmpty() && protocols.size() % 2 == 0) {
                for (int i = 0; i < protocols.size(); i += 2) {
                    try {
                        String name = URLDecoder.decode(protocols.get(i), StandardCharsets.UTF_8);
                        String value = URLDecoder.decode(protocols.get(i + 1), StandardCharsets.UTF_8);
                        requestBuilder.header(name, value);
                        se.getRequestHeaders().put(new HttpString(name), value);
                        continue;
                    }
                    catch (Throwable e) {
                        log.warn("Failed to convert a protocol to a ");
                    }
                }
            }
            return requestBuilder.method("WS_HANDSHAKE").build();
        }
        return webRequest;
    }

    static List<String> getWebsocketProtocols(List<String> headerValue) {
        if (headerValue == null || headerValue.isEmpty()) {
            return Collections.emptyList();
        }
        return headerValue.stream().flatMap(protocolHeader -> Arrays.stream(protocolHeader.split(",")).map(String::trim)).toList();
    }

    protected void sendWebRequest(HttpServerExchange se, WebRequest webRequest) {
        SerializedMessage requestMessage = webRequest.serialize((Serializer)this.serializer);
        this.requestHandler.sendRequest(requestMessage, m -> this.requestGateway.append(Guarantee.SENT, new SerializedMessage[]{m}), intermediateResponse -> this.handleResponse((SerializedMessage)intermediateResponse, webRequest, se)).whenComplete((r, e) -> {
            try {
                e = ObjectUtils.unwrapException((Throwable)e);
                if (e == null) {
                    this.handleResponse((SerializedMessage)r, webRequest, se);
                } else if (e instanceof TimeoutException) {
                    log.warn("Request {} timed out (messageId: {}). This is possibly due to a missing handler.", new Object[]{webRequest, webRequest.getMessageId(), e});
                    this.sendGatewayTimeout(se);
                } else {
                    log.error("Failed to complete {} (messageId: {})", new Object[]{webRequest, webRequest.getMessageId(), e});
                    this.sendServerError(se);
                }
            }
            catch (Throwable t) {
                log.error("Failed to process response {} to request {}", new Object[]{e == null ? r : e, webRequest, t});
                this.sendServerError(se);
            }
        });
    }

    protected void handleResponse(SerializedMessage responseMessage, WebRequest webRequest, HttpServerExchange se) {
        int statusCode = WebResponse.getStatusCode((Metadata)responseMessage.getMetadata());
        if (statusCode < 300 && "WS_HANDSHAKE".equals(webRequest.getMethod())) {
            se.addQueryParam("_clientId", responseMessage.getMetadata().get((Object)"clientId"));
            se.addQueryParam("_trackerId", responseMessage.getMetadata().get((Object)"trackerId"));
            this.websocketHandler.handleRequest(se);
            return;
        }
        if (responseMessage.chunked()) {
            if (!se.isBlocking()) {
                this.prepareForSending(responseMessage, se, statusCode).startBlocking();
            }
            OutputStream out = se.getOutputStream();
            out.write((byte[])responseMessage.getData().getValue());
            if (responseMessage.lastChunk()) {
                out.close();
            }
        } else {
            this.sendResponse(responseMessage, this.prepareForSending(responseMessage, se, statusCode));
        }
    }

    protected HttpServerExchange prepareForSending(SerializedMessage responseMessage, HttpServerExchange se, int statusCode) {
        se.setStatusCode(statusCode);
        boolean http2 = se.getProtocol().compareTo(Protocols.HTTP_1_1) > 0;
        Map headers = WebUtils.getHeaders((Metadata)responseMessage.getMetadata());
        headers.forEach((key, value) -> {
            if (http2 || !key.startsWith(":")) {
                se.getResponseHeaders().addAll(new HttpString(key), (Collection)value);
            }
        });
        if (!se.getResponseHeaders().contains("Content-Type")) {
            Optional.ofNullable(responseMessage.getData().getFormat()).ifPresent(format -> se.getResponseHeaders().add(new HttpString("Content-Type"), format));
        }
        return se;
    }

    protected void sendResponse(SerializedMessage responseMessage, HttpServerExchange se) {
        se.getResponseSender().send(ByteBuffer.wrap((byte[])responseMessage.getData().getValue()));
    }

    protected void sendServerError(HttpServerExchange se) {
        try {
            se.setStatusCode(500);
            se.getResponseSender().send("Request could not be handled due to a server side error");
        }
        catch (Throwable t) {
            log.error("Failed to send server error response", t);
        }
    }

    protected void sendGatewayTimeout(HttpServerExchange se) {
        se.setStatusCode(504);
        se.getResponseSender().send("Did not receive a response in time");
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.websocketEndpoint.shutDown();
            this.requestHandler.close();
            this.requestGateway.close();
        }
    }

    protected HttpHandler createWebsocketHandler() {
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(Servlets.deployment().setContextPath("/**").addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)new WebSocketDeploymentInfo().setBuffers((ByteBufferPool)new DefaultByteBufferPool(false, 1024, 100, 12)).setWorker(Xnio.getInstance().createWorker(OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true))).addEndpoint(ServerEndpointConfig.Builder.create(WebsocketEndpoint.class, (String)"/**").configurator(new ServerEndpointConfig.Configurator(){

            public <T> T getEndpointInstance(Class<T> endpointClass) {
                return endpointClass.cast((Object)ProxyRequestHandler.this.websocketEndpoint);
            }

            public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
                super.modifyHandshake(sec, request, response);
                List<String> protocols = ProxyRequestHandler.getWebsocketProtocols((List)request.getHeaders().get("Sec-WebSocket-Protocol"));
                if (!protocols.isEmpty()) {
                    response.getHeaders().put("Sec-WebSocket-Protocol", List.of(protocols.getFirst()));
                }
            }
        }).build())).setDeploymentName("websocket").addFilter(new FilterInfo("websocketFilter", WebsocketFilter.class)).addFilterUrlMapping("websocketFilter", "*", DispatcherType.REQUEST).setClassLoader(Undertow.class.getClassLoader()));
        deploymentManager.deploy();
        return deploymentManager.start();
    }
}

