/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.application;

import io.fluxzero.common.application.NoOpPropertySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface PropertySource {
    public static final Pattern substitutionPattern = Pattern.compile("[$][{]([^${}]+)}");

    public String get(String var1);

    default public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    default public boolean getBoolean(String name, boolean defaultValue) {
        return Optional.ofNullable(this.get(name)).map("true"::equalsIgnoreCase).orElse(defaultValue);
    }

    default public String get(String name, String defaultValue) {
        return Optional.ofNullable(this.get(name)).orElse(defaultValue);
    }

    default public String require(String name) {
        return Optional.ofNullable(this.get(name)).orElseThrow(() -> new IllegalStateException(String.format("Property for %s is missing", name)));
    }

    default public boolean containsProperty(String name) {
        return this.get(name) != null;
    }

    default public String substituteProperties(String template) {
        Matcher matcher = substitutionPattern.matcher(template);
        StringBuilder resultBuilder = new StringBuilder(template);
        ArrayList<String> valueList = new ArrayList<String>();
        while (matcher.find()) {
            String value;
            String key = matcher.group(1);
            String paramName = "${" + key + "}";
            int index = resultBuilder.indexOf(paramName);
            if (index == -1) continue;
            resultBuilder.replace(index, index + paramName.length(), "%s");
            String[] keyWithDefault = key.split(":", 2);
            if (keyWithDefault.length == 1) {
                value = this.get(key);
                if (value == null) {
                    LoggerFactory.getLogger(this.getClass()).warn("Property named \"{}\" hasn't been set", (Object)key);
                }
            } else {
                value = this.get(keyWithDefault[0], keyWithDefault[1]);
            }
            valueList.add(value == null ? "" : value);
        }
        String result = String.format(resultBuilder.toString(), valueList.toArray());
        return result.equals(template) ? result : this.substituteProperties(result);
    }

    default public PropertySource andThen(PropertySource next) {
        return name -> Optional.ofNullable(this.get(name)).orElseGet(() -> next.get(name));
    }

    public static PropertySource join(PropertySource ... propertySources) {
        return Arrays.stream(propertySources).reduce(PropertySource::andThen).orElse(NoOpPropertySource.INSTANCE);
    }
}

