/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.handling;

import io.fluxzero.common.handling.HandlerInvoker;
import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.stream.Stream;

public interface HandlerMatcher<T, M> {
    public boolean canHandle(M var1);

    public Stream<Executable> matchingMethods(M var1);

    public Optional<HandlerInvoker> getInvoker(T var1, M var2);

    default public HandlerMatcher<T, M> or(final HandlerMatcher<T, M> next) {
        final HandlerMatcher first = this;
        return new HandlerMatcher<T, M>(){

            @Override
            public boolean canHandle(M message) {
                return first.canHandle(message) || next.canHandle(message);
            }

            @Override
            public Stream<Executable> matchingMethods(M message) {
                return Stream.concat(first.matchingMethods(message), next.matchingMethods(message));
            }

            @Override
            public Optional<HandlerInvoker> getInvoker(T target, M message) {
                return first.getInvoker(target, message).or(() -> next.getInvoker(target, message));
            }
        };
    }
}

