/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.serialization;

import io.fluxzero.common.reflection.ReflectionUtils;
import io.fluxzero.common.serialization.TypeRegistry;
import io.fluxzero.common.serialization.TypeRegistryProcessor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeRegistry
implements TypeRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTypeRegistry.class);
    private final SortedSet<String> fullTypeNames;
    private final Map<String, String> types;

    static List<String> loadAllRegisteredTypes() {
        ArrayList<String> allTypes = new ArrayList<String>();
        Enumeration<URL> resources = TypeRegistry.class.getClassLoader().getResources(TypeRegistryProcessor.TYPES_FILE);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    allTypes.add(line);
                }
            }
        }
        return allTypes;
    }

    public DefaultTypeRegistry() {
        this(DefaultTypeRegistry.loadAllRegisteredTypes());
    }

    protected DefaultTypeRegistry(List<String> candidates) {
        this.fullTypeNames = new TreeSet<String>(candidates);
        TreeMap<String, String> types = new TreeMap<String, String>();
        for (String fqn : candidates) {
            if (fqn == null || fqn.isBlank()) continue;
            types.putIfAbsent(ReflectionUtils.getSimpleName(fqn), fqn);
        }
        this.types = types;
    }

    @Override
    public Optional<String> getTypeName(String alias) {
        return Optional.ofNullable(this.types.get(alias)).or(() -> {
            Object suffix = alias.startsWith(".") ? alias : "." + alias;
            return this.fullTypeNames.stream().filter(arg_0 -> DefaultTypeRegistry.lambda$getTypeName$1((String)suffix, arg_0)).findFirst();
        });
    }

    private static /* synthetic */ boolean lambda$getTypeName$1(String suffix, String t) {
        return t.endsWith(suffix);
    }
}

