/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.ObjectUtils;
import java.util.Objects;
import java.util.function.Predicate;

public interface ThrowingPredicate<T> {
    public boolean test(T var1) throws Exception;

    default public ThrowingPredicate<T> and(ThrowingPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public ThrowingPredicate<T> negate() {
        return t -> !this.test(t);
    }

    default public ThrowingPredicate<T> or(ThrowingPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> ThrowingPredicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    public static <T> ThrowingPredicate<T> not(ThrowingPredicate<? super T> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }

    default public Predicate<T> asPredicate() {
        return t -> ObjectUtils.call(() -> this.test(t));
    }
}

