/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.constraints;

import com.fasterxml.jackson.annotation.JsonAlias;
import io.fluxzero.common.api.search.Constraint;
import io.fluxzero.common.search.Document;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import lombok.Generated;

public abstract class PathConstraint
implements Constraint {
    private final AtomicReference<Object> documentPredicate = new AtomicReference();

    @JsonAlias(value={"path"})
    public abstract List<String> getPaths();

    public abstract Constraint withPaths(List<String> var1);

    protected abstract boolean matches(Document.Entry var1, Document var2);

    @Override
    public boolean matches(Document document) {
        return this.documentPredicate().test(document);
    }

    @Override
    public boolean hasPathConstraint() {
        return !this.getPaths().isEmpty();
    }

    protected boolean checkPathBeforeEntry() {
        return false;
    }

    private Predicate<Document> computeDocumentPredicate() {
        Predicate pathPredicate = this.getPaths().stream().map(Document.Path::pathPredicate).reduce(Predicate::or).orElseGet(() -> p -> true);
        return this.checkPathBeforeEntry() ? d -> d.getEntries().entrySet().stream().anyMatch(e -> ((List)e.getValue()).stream().anyMatch(pathPredicate) && this.matches((Document.Entry)e.getKey(), (Document)d)) : d -> d.getEntries().entrySet().stream().anyMatch(e -> this.matches((Document.Entry)e.getKey(), (Document)d) && (((List)e.getValue()).isEmpty() ? pathPredicate.test(Document.Path.EMPTY_PATH) : ((List)e.getValue()).stream().anyMatch(pathPredicate)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected Predicate<Document> documentPredicate() {
        Object $value = this.documentPredicate.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.documentPredicate;
            synchronized (atomicReference) {
                $value = this.documentPredicate.get();
                if ($value == null) {
                    Predicate<Document> actualValue = this.computeDocumentPredicate();
                    $value = actualValue == null ? this.documentPredicate : actualValue;
                    this.documentPredicate.set($value);
                }
            }
        }
        return (Predicate)($value == this.documentPredicate ? null : $value);
    }
}

