/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.constraints;

import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.api.search.constraints.PathConstraint;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public final class BetweenConstraint
extends PathConstraint {
    private final Object min;
    private final Object max;
    private final List<String> paths;
    private final AtomicReference<Object> matcher = new AtomicReference();

    public static BetweenConstraint between(Object min, Object maxExclusive, @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(BetweenConstraint.formatConstraintValue(min), BetweenConstraint.formatConstraintValue(maxExclusive), List.of(path));
    }

    public static BetweenConstraint atLeast(@NonNull Object min, @NonNull String path) {
        if (min == null) {
            throw new NullPointerException("min is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(BetweenConstraint.formatConstraintValue(min), null, List.of(path));
    }

    public static BetweenConstraint below(@NonNull Object maxExclusive, @NonNull String path) {
        if (maxExclusive == null) {
            throw new NullPointerException("maxExclusive is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new BetweenConstraint(null, BetweenConstraint.formatConstraintValue(maxExclusive), List.of(path));
    }

    static Object formatConstraintValue(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instant.class, Number.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Instant instant = (Instant)object;
                yield SearchUtils.ISO_FULL.format(instant);
            }
            case 1 -> {
                Number number = (Number)object;
                yield number;
            }
            default -> value.toString().toLowerCase();
        };
    }

    @Override
    protected boolean matches(Document.Entry entry) {
        return this.matcher().test(entry);
    }

    @Override
    protected boolean checkPathBeforeEntry() {
        return true;
    }

    Predicate<Document.Entry> computeEntryPredicate() {
        Document.Entry minEntry = BetweenConstraint.asEntry(this.min);
        Document.Entry maxEntry = BetweenConstraint.asEntry(this.max);
        return this.min == null ? (this.max == null ? s -> true : s -> s.compareTo(maxEntry) < 0) : (this.max == null ? s -> s.compareTo(minEntry) >= 0 : s -> s.compareTo(minEntry) >= 0 && s.compareTo(maxEntry) < 0);
    }

    static Document.Entry asEntry(Object input) {
        return input == null ? null : new Document.Entry(input instanceof Number ? Document.EntryType.NUMERIC : Document.EntryType.TEXT, input.toString());
    }

    @Generated
    public Object getMin() {
        return this.min;
    }

    @Generated
    public Object getMax() {
        return this.max;
    }

    @Override
    @Generated
    public List<String> getPaths() {
        return this.paths;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenConstraint)) {
            return false;
        }
        BetweenConstraint other = (BetweenConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$min = this.getMin();
        Object other$min = other.getMin();
        if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
            return false;
        }
        Object this$max = this.getMax();
        Object other$max = other.getMax();
        if (this$max == null ? other$max != null : !this$max.equals(other$max)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BetweenConstraint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        Object $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BetweenConstraint(min=" + String.valueOf(this.getMin()) + ", max=" + String.valueOf(this.getMax()) + ", paths=" + String.valueOf(this.getPaths()) + ", matcher=" + String.valueOf(this.matcher()) + ")";
    }

    @ConstructorProperties(value={"min", "max", "paths"})
    @Generated
    private BetweenConstraint(Object min, Object max, List<String> paths) {
        this.min = min;
        this.max = max;
        this.paths = paths;
    }

    @Override
    @Generated
    public BetweenConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new BetweenConstraint(this.min, this.max, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected Predicate<Document.Entry> matcher() {
        Object $value = this.matcher.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.matcher;
            synchronized (atomicReference) {
                $value = this.matcher.get();
                if ($value == null) {
                    Predicate<Document.Entry> actualValue = this.computeEntryPredicate();
                    $value = actualValue == null ? this.matcher : actualValue;
                    this.matcher.set($value);
                }
            }
        }
        return (Predicate)($value == this.matcher ? null : $value);
    }
}

