/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.fluxzero.common.FileUtils;
import io.fluxzero.common.reflection.ReflectionUtils;
import io.fluxzero.common.serialization.GlobalTypeIdResolver;
import io.fluxzero.common.serialization.NullCollectionsAsEmptyModule;
import io.fluxzero.common.serialization.StripStringsModule;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static JsonMapper writer = (JsonMapper)JsonUtils.defaultWriterBuilder().build();
    public static JsonMapper reader = (JsonMapper)((JsonMapper.Builder)writer.rebuild().setDefaultTyping((TypeResolverBuilder)new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, (PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance).init(JsonTypeInfo.Id.CLASS, (TypeIdResolver)new GlobalTypeIdResolver()).inclusion(JsonTypeInfo.As.PROPERTY))).build();
    private static final Pattern extendsPattern = Pattern.compile("(\"@extends?\"\\s*:\\s*\"([^\"]+)\"\\s*,?)");

    public static JsonMapper.Builder defaultWriterBuilder() {
        JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new StripStringsModule())).addModule((Module)new NullCollectionsAsEmptyModule())).addModule((Module)new Jdk8Module());
        builder = JsonUtils.tryAddKotlinModule(builder);
        return (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)builder.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS})).enable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_WITH_ZONE_ID})).disable(new DeserializationFeature[]{DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).disable(new DatatypeFeature[]{JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES})).enable(new DeserializationFeature[]{DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS})).serializationInclusion(JsonInclude.Include.NON_NULL)).findAndAddModules();
    }

    static JsonMapper.Builder tryAddKotlinModule(JsonMapper.Builder builder) {
        try {
            Class<?> moduleClass = ReflectionUtils.classForName("com.fasterxml.jackson.module.kotlin.KotlinModule$Builder");
            Object builderInstance = ReflectionUtils.asInstance(moduleClass);
            Object kotlinModule = moduleClass.getMethod("build", new Class[0]).invoke(builderInstance, new Object[0]);
            return (JsonMapper.Builder)builder.addModule((Module)kotlinModule);
        }
        catch (Throwable ignored) {
            return builder;
        }
    }

    public static Object fromFile(String fileName) {
        return JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName);
    }

    public static List<?> fromFile(String ... fileNames) {
        Class<?> callerClass = ReflectionUtils.getCallerClass();
        return Arrays.stream(fileNames).map(f -> JsonUtils.fromFile(callerClass, f)).collect(Collectors.toList());
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName) {
        String content = JsonUtils.getContent(referencePoint, fileName);
        return (T)reader.readValue(content, Object.class);
    }

    protected static String getContent(Class<?> referencePoint, String fileName) {
        URL resource = referencePoint.getResource(fileName);
        if (resource == null) {
            log.error("Resource {} not found in package {}", (Object)fileName, (Object)referencePoint.getPackageName());
            throw new IllegalArgumentException("File not found: " + fileName);
        }
        return JsonUtils.getContent(resource.toURI());
    }

    protected static String getContent(URI fileUri) {
        String content = FileUtils.loadFile(fileUri);
        AtomicReference extendsReference = new AtomicReference();
        content = extendsPattern.matcher(content).replaceFirst(m -> {
            extendsReference.set(m.group(2));
            return "";
        });
        String extendsFile = (String)extendsReference.get();
        if (extendsFile != null) {
            String extendsContent;
            if (extendsFile.startsWith("/")) {
                URL extendsResource = JsonUtils.class.getResource(extendsFile);
                if (extendsResource == null) {
                    log.error("Resource {} not found", (Object)extendsFile);
                    throw new IllegalArgumentException("File not found: " + extendsFile);
                }
                extendsContent = JsonUtils.getContent(extendsResource.toURI());
            } else {
                extendsContent = JsonUtils.getContent(FileUtils.safeResolve(fileUri, extendsFile));
            }
            JsonNode baseNode = reader.readTree(extendsContent);
            reader.readerForUpdating((Object)baseNode).readValue(reader.readTree(content));
            content = reader.writeValueAsString((Object)baseNode);
        }
        return content;
    }

    public static <T> T fromFile(String fileName, Class<T> type) {
        return JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName, type);
    }

    public static <T> T fromFile(String fileName, JavaType javaType) {
        return (T)writer.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), javaType);
    }

    public static <T> T fromFile(String fileName, Function<TypeFactory, JavaType> typeFunction) {
        return (T)writer.readValue(FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName), typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, Class<T> type) {
        return JsonUtils.fromJson(FileUtils.loadFile(referencePoint, fileName), type);
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, JavaType javaType) {
        return (T)writer.readValue(FileUtils.loadFile(referencePoint, fileName), javaType);
    }

    public static <T> T fromFile(Class<?> referencePoint, String fileName, Function<TypeFactory, JavaType> typeFunction) {
        return (T)writer.readValue(FileUtils.loadFile(referencePoint, fileName), typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromFileAs(String fileName) {
        return JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName);
    }

    public static Object fromFileWith(String fileName, Map<String, Object> replaceValues) {
        Object o = JsonUtils.fromFile(ReflectionUtils.getCallerClass(), fileName);
        replaceValues.forEach((path, replacement) -> ReflectionUtils.writeProperty(path, o, replacement));
        return o;
    }

    public static <T> T fromJson(String json) {
        return (T)reader.readValue(json, Object.class);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        return (T)JsonUtils.selectMapper(type).readValue(json, type);
    }

    public static <T> T fromJson(String json, Type type) {
        return JsonUtils.fromJson(json, writer.constructType(type));
    }

    public static <T> T fromJson(String json, JavaType type) {
        return (T)writer.readValue(json, type);
    }

    public static <T> T fromJson(String json, Function<TypeFactory, JavaType> typeFunction) {
        return (T)writer.readValue(json, typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static <T> T fromJson(byte[] json, Class<T> type) {
        return (T)JsonUtils.selectMapper(type).readValue(json, type);
    }

    public static <T> T fromJson(byte[] json) {
        return (T)reader.readValue(json, Object.class);
    }

    public static <T> T fromJson(byte[] json, Type type) {
        return JsonUtils.fromJson(json, writer.constructType(type));
    }

    public static <T> T fromJson(byte[] json, JavaType type) {
        return (T)writer.readValue(json, type);
    }

    public static <T> T fromJson(byte[] json, Function<TypeFactory, JavaType> typeFunction) {
        return (T)writer.readValue(json, typeFunction.apply(JsonUtils.typeFactory()));
    }

    static JsonMapper selectMapper(Class<?> type) {
        return Object.class.equals(type) || Collection.class.isAssignableFrom(type) ? reader : writer;
    }

    public static String asJson(Object object) {
        return writer.writeValueAsString(object);
    }

    public static String asPrettyJson(Object object) {
        return writer.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static byte[] asBytes(Object object) {
        return writer.writeValueAsBytes(object);
    }

    public static <T> T convertValue(Object fromValue, Class<? extends T> toValueType) {
        return JsonUtils.convertValue(fromValue, toValueType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T convertValue(Object fromValue, Type toValueType) {
        if (fromValue instanceof byte[]) {
            byte[] input = (byte[])fromValue;
            if (!byte[].class.equals((Object)toValueType)) {
                fromValue = JsonUtils.readTree(input);
                return (T)writer.convertValue(fromValue, writer.constructType(toValueType));
            }
        }
        if (!(fromValue instanceof String)) return (T)writer.convertValue(fromValue, writer.constructType(toValueType));
        String input = (String)fromValue;
        if (String.class.equals((Object)toValueType)) return (T)writer.convertValue(fromValue, writer.constructType(toValueType));
        fromValue = JsonUtils.readTree(input);
        return (T)writer.convertValue(fromValue, writer.constructType(toValueType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T convertValue(Object fromValue, TypeReference<T> typeRef) {
        if (fromValue instanceof byte[]) {
            byte[] input = (byte[])fromValue;
            if (!byte[].class.equals((Object)typeRef.getType())) {
                fromValue = JsonUtils.readTree(input);
                return (T)writer.convertValue(fromValue, typeRef);
            }
        }
        if (!(fromValue instanceof String)) return (T)writer.convertValue(fromValue, typeRef);
        String input = (String)fromValue;
        if (String.class.equals((Object)typeRef.getType())) return (T)writer.convertValue(fromValue, typeRef);
        fromValue = JsonUtils.readTree(input);
        return (T)writer.convertValue(fromValue, typeRef);
    }

    public static <T> T convertValue(Object fromValue, Function<TypeFactory, JavaType> typeFunction) {
        return (T)writer.convertValue(fromValue, typeFunction.apply(JsonUtils.typeFactory()));
    }

    public static JsonNode readTree(byte[] jsonContent) {
        return writer.readTree(jsonContent);
    }

    public static JsonNode readTree(String jsonContent) {
        return writer.readTree(jsonContent);
    }

    public static JsonNode readTree(InputStream jsonContent) {
        return writer.readTree(jsonContent);
    }

    public static <T extends JsonNode> T valueToTree(Object object) {
        return (T)writer.valueToTree(object);
    }

    public static ObjectNode newObjectNode(Object ... keyValues) {
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("Expected even number of keys + values but got: " + keyValues.length);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return JsonUtils.convertValue(map, ObjectNode.class);
    }

    public static <T> T merge(T base, Object update) {
        if (update == null) {
            return base;
        }
        if (base == null) {
            return (T)update;
        }
        if (Objects.equals(base, update)) {
            return base;
        }
        ObjectNode result = (ObjectNode)JsonUtils.valueToTree(base);
        ObjectNode toAdd = (ObjectNode)JsonUtils.valueToTree(update);
        Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            if (!((JsonNode)iterator.next()).isNull()) continue;
            iterator.remove();
        }
        result.setAll(toAdd);
        return (T)JsonUtils.convertValue((Object)result, base.getClass());
    }

    public static TypeFactory typeFactory() {
        return writer.getTypeFactory();
    }

    public static void disableJsonIgnore(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return false;
            }
        });
    }
}

