/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.reflection;

import io.fluxzero.common.reflection.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;

public class KotlinReflectionUtils {
    public static KParameter asKotlinParameter(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        int paramIndex = ReflectionUtils.getParameterIndex(parameter);
        KFunction<?> kotlinFunction = KotlinReflectionUtils.asKotlinFunction(executable);
        if (kotlinFunction == null) {
            throw new IllegalStateException("Could not obtain Kotlin function for: " + String.valueOf(executable));
        }
        return kotlinFunction.getParameters().stream().filter(p -> p.getKind() == KParameter.Kind.VALUE).skip(paramIndex).findFirst().orElse(null);
    }

    public static KFunction<?> asKotlinFunction(Executable executable) {
        return executable instanceof Method ? ReflectJvmMapping.getKotlinFunction((Method)((Method)executable)) : ReflectJvmMapping.getKotlinFunction((Constructor)((Constructor)executable));
    }

    public static Class<?> convertIfKotlinClass(Object classObject) {
        Class clazz;
        if (classObject instanceof KClass) {
            KClass k = (KClass)classObject;
            clazz = JvmClassMappingKt.getJavaClass((KClass)k);
        } else {
            clazz = null;
        }
        return clazz;
    }
}

