/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.handling;

import io.fluxzero.common.handling.DefaultHandler;
import io.fluxzero.common.handling.Handler;
import io.fluxzero.common.handling.HandlerConfiguration;
import io.fluxzero.common.handling.HandlerInvoker;
import io.fluxzero.common.handling.HandlerMatcher;
import io.fluxzero.common.handling.ParameterResolver;
import io.fluxzero.common.reflection.DefaultMemberInvoker;
import io.fluxzero.common.reflection.MemberInvoker;
import io.fluxzero.common.reflection.ReflectionUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class HandlerInspector {
    public static boolean hasHandlerMethods(Class<?> targetClass, HandlerConfiguration<?> handlerConfiguration) {
        return Stream.concat(ReflectionUtils.getAllMethods(targetClass).stream(), Arrays.stream(targetClass.getConstructors())).anyMatch(m -> handlerConfiguration.methodMatches(targetClass, (Executable)m));
    }

    public static <M> Handler<M> createHandler(Object target, Class<? extends Annotation> methodAnnotation) {
        return HandlerInspector.createHandler(target, methodAnnotation, List.of((p, a) -> o -> o));
    }

    public static <M> Handler<M> createHandler(Object target, Class<? extends Annotation> methodAnnotation, List<ParameterResolver<? super M>> parameterResolvers) {
        return HandlerInspector.createHandler(target, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(methodAnnotation).build());
    }

    public static <M> Handler<M> createHandler(Object target, List<ParameterResolver<? super M>> parameterResolvers, HandlerConfiguration<? super M> config) {
        return HandlerInspector.createHandler(m -> target, target.getClass(), parameterResolvers, config);
    }

    public static <M> Handler<M> createHandler(Function<M, ?> targetSupplier, Class<?> targetClass, List<ParameterResolver<? super M>> parameterResolvers, HandlerConfiguration<? super M> config) {
        return new DefaultHandler<M>(targetClass, targetSupplier, HandlerInspector.inspect(targetClass, parameterResolvers, config));
    }

    public static <M> HandlerMatcher<Object, M> inspect(Class<?> targetClass, List<ParameterResolver<? super M>> parameterResolvers, Class<? extends Annotation> methodAnnotation) {
        return HandlerInspector.inspect(targetClass, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(methodAnnotation).build());
    }

    public static <M> HandlerMatcher<Object, M> inspect(Class<?> targetClass, List<ParameterResolver<? super M>> parameterResolvers, HandlerConfiguration<? super M> config) {
        return new ObjectHandlerMatcher(Stream.concat(ReflectionUtils.getAllMethods(targetClass).stream(), Arrays.stream(targetClass.getDeclaredConstructors())).filter(m -> config.methodMatches(targetClass, (Executable)m)).flatMap(m -> Stream.of(new MethodHandlerMatcher((Executable)m, targetClass, parameterResolvers, config))).sorted(MethodHandlerMatcher.comparator).collect(Collectors.toList()), config.invokeMultipleMethods());
    }

    public static class ObjectHandlerMatcher<M>
    implements HandlerMatcher<Object, M> {
        private final List<HandlerMatcher<Object, M>> methodHandlers;
        private final boolean invokeMultipleMethods;

        @Override
        public boolean canHandle(M message) {
            for (HandlerMatcher<Object, M> d : this.methodHandlers) {
                if (!d.canHandle(message)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Stream<Executable> matchingMethods(M message) {
            return this.methodHandlers.stream().flatMap(m -> m.matchingMethods(message));
        }

        @Override
        public Optional<HandlerInvoker> getInvoker(Object target, M message) {
            if (this.invokeMultipleMethods) {
                ArrayList invokers = new ArrayList();
                for (HandlerMatcher<Object, M> d : this.methodHandlers) {
                    Optional<HandlerInvoker> s = d.getInvoker(target, message);
                    s.ifPresent(invokers::add);
                }
                return HandlerInvoker.join(invokers);
            }
            for (HandlerMatcher<Object, M> d : this.methodHandlers) {
                Optional<HandlerInvoker> s = d.getInvoker(target, message);
                if (!s.isPresent()) continue;
                return s;
            }
            return Optional.empty();
        }

        @ConstructorProperties(value={"methodHandlers", "invokeMultipleMethods"})
        @Generated
        public ObjectHandlerMatcher(List<HandlerMatcher<Object, M>> methodHandlers, boolean invokeMultipleMethods) {
            this.methodHandlers = methodHandlers;
            this.invokeMultipleMethods = invokeMultipleMethods;
        }
    }

    public static class MethodHandlerMatcher<M>
    implements HandlerMatcher<Object, M> {
        protected static final Comparator<MethodHandlerMatcher<?>> comparator = Comparator.comparing(MethodHandlerMatcher::getPriority, Comparator.reverseOrder()).thenComparing(MethodHandlerMatcher::getClassForSpecificity, ReflectionUtils.getClassSpecificityComparator()).thenComparingInt(a -> -a.getParameterCount()).thenComparingInt(MethodHandlerMatcher::getMethodIndex);
        private final int methodIndex;
        private final Executable executable;
        private final Parameter[] parameters;
        private final int parameterCount;
        private final boolean staticMethod;
        private final MemberInvoker invoker;
        private final boolean hasReturnValue;
        private final Class<?> classForSpecificity;
        private final Annotation methodAnnotation;
        private final Class<? extends Annotation> methodAnnotationType;
        private final int priority;
        private final boolean passive;
        private final Class<?> targetClass;
        private final List<ParameterResolver<? super M>> parameterResolvers;
        private final HandlerConfiguration<? super M> config;
        private final Optional<Object> emptyResult = Optional.of(Void.TYPE);

        public MethodHandlerMatcher(Executable executable, Class<?> targetClass, List<ParameterResolver<? super M>> parameterResolvers, @NonNull HandlerConfiguration<? super M> config) {
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            this.targetClass = targetClass;
            this.parameterResolvers = parameterResolvers;
            this.config = config;
            this.methodIndex = executable instanceof Method ? this.methodIndex((Method)executable, targetClass) : 0;
            this.executable = ReflectionUtils.ensureAccessible(executable);
            this.parameters = this.executable.getParameters();
            this.parameterCount = this.parameters.length;
            this.staticMethod = Modifier.isStatic(this.executable.getModifiers());
            this.hasReturnValue = !(executable instanceof Method) || !((Method)executable).getReturnType().equals(Void.TYPE);
            this.methodAnnotation = config.getAnnotation(executable).orElse(null);
            this.methodAnnotationType = Optional.ofNullable(this.methodAnnotation).map(Annotation::annotationType).orElse(null);
            this.classForSpecificity = this.computeClassForSpecificity();
            this.priority = this.getPriority(this.methodAnnotation);
            this.passive = this.isPassive(this.methodAnnotation);
            this.invoker = DefaultMemberInvoker.asInvoker(this.executable);
        }

        @Override
        public boolean canHandle(M message) {
            return this.prepareInvoker(message).isPresent();
        }

        @Override
        public Stream<Executable> matchingMethods(M message) {
            return this.canHandle(message) ? Stream.of(this.executable) : Stream.empty();
        }

        protected Optional<Function<Object, HandlerInvoker>> prepareInvoker(final M m) {
            if (!this.config.messageFilter().test(m, this.executable, this.methodAnnotationType)) {
                return Optional.empty();
            }
            if (this.parameterCount == 0) {
                return Optional.of(target -> new MethodHandlerInvoker(){

                    @Override
                    public Object invoke(BiFunction<Object, Object, Object> combiner) {
                        return invoker.invoke(target);
                    }
                });
            }
            final Function[] matchingResolvers = new Function[this.parameterCount];
            for (int i = 0; i < this.parameterCount; ++i) {
                Parameter p = this.parameters[i];
                ParameterResolver<M> matchingResolver = null;
                for (ParameterResolver<M> r : this.parameterResolvers) {
                    if (!r.matches(p, this.methodAnnotation, m)) continue;
                    matchingResolver = r;
                    break;
                }
                if (matchingResolver == null || !matchingResolver.filterMessage(m, p)) {
                    return Optional.empty();
                }
                matchingResolvers[i] = matchingResolver.resolve(p, this.methodAnnotation);
            }
            return Optional.of(target -> new MethodHandlerInvoker(){

                @Override
                public Object invoke(BiFunction<Object, Object, Object> combiner) {
                    return invoker.invoke(target, parameterCount, i -> matchingResolvers[i].apply(m));
                }
            });
        }

        @Override
        public Optional<HandlerInvoker> getInvoker(Object target, M m) {
            if (target == null ? !(this.executable instanceof Constructor) && !this.staticMethod : !(this.executable instanceof Method) || this.staticMethod) {
                return Optional.empty();
            }
            return this.prepareInvoker(m).map(f -> (HandlerInvoker)f.apply(target));
        }

        protected Class<?> computeClassForSpecificity() {
            Class handlerType = this.config.messageFilter().getLeastSpecificAllowedClass(this.executable, this.methodAnnotationType).orElse(null);
            for (Parameter p : this.parameters) {
                for (ParameterResolver<M> r : this.parameterResolvers) {
                    Function<? super M, Object> resolver;
                    if (!r.determinesSpecificity() || (resolver = r.resolve(p, this.methodAnnotation)) == null) continue;
                    Class<?> parameterType = p.getType();
                    if (handlerType != null && !handlerType.isAssignableFrom(parameterType)) {
                        return handlerType;
                    }
                    return parameterType;
                }
            }
            return handlerType;
        }

        protected int methodIndex(Method instanceMethod, Class<?> instanceType) {
            return ReflectionUtils.getAllMethods(instanceType).indexOf(instanceMethod);
        }

        protected int getPriority(Annotation annotation) {
            if (annotation == null) {
                return 0;
            }
            Optional<Method> match = Arrays.stream(annotation.annotationType().getMethods()).filter(m -> m.getName().equals("priority")).findFirst();
            if (match.isPresent()) {
                return (Integer)match.get().invoke((Object)annotation, new Object[0]);
            }
            return 0;
        }

        protected boolean isPassive(Annotation annotation) {
            if (annotation == null) {
                return false;
            }
            Optional<Method> match = Arrays.stream(annotation.annotationType().getMethods()).filter(m -> m.getName().equals("passive")).findFirst();
            if (match.isPresent()) {
                return (Boolean)match.get().invoke((Object)annotation, new Object[0]);
            }
            return false;
        }

        @Generated
        public int getMethodIndex() {
            return this.methodIndex;
        }

        @Generated
        public Executable getExecutable() {
            return this.executable;
        }

        @Generated
        public Parameter[] getParameters() {
            return this.parameters;
        }

        @Generated
        public int getParameterCount() {
            return this.parameterCount;
        }

        @Generated
        public boolean isStaticMethod() {
            return this.staticMethod;
        }

        @Generated
        public MemberInvoker getInvoker() {
            return this.invoker;
        }

        @Generated
        public boolean isHasReturnValue() {
            return this.hasReturnValue;
        }

        @Generated
        public Class<?> getClassForSpecificity() {
            return this.classForSpecificity;
        }

        @Generated
        public Annotation getMethodAnnotation() {
            return this.methodAnnotation;
        }

        @Generated
        public Class<? extends Annotation> getMethodAnnotationType() {
            return this.methodAnnotationType;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public boolean isPassive() {
            return this.passive;
        }

        @Generated
        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        @Generated
        public List<ParameterResolver<? super M>> getParameterResolvers() {
            return this.parameterResolvers;
        }

        @Generated
        public HandlerConfiguration<? super M> getConfig() {
            return this.config;
        }

        @Generated
        public Optional<Object> getEmptyResult() {
            return this.emptyResult;
        }

        protected abstract class MethodHandlerInvoker
        implements HandlerInvoker {
            @Override
            public Class<?> getTargetClass() {
                return MethodHandlerMatcher.this.targetClass;
            }

            @Override
            public Executable getMethod() {
                return MethodHandlerMatcher.this.executable;
            }

            @Override
            public <A extends Annotation> A getMethodAnnotation() {
                return (A)MethodHandlerMatcher.this.methodAnnotation;
            }

            @Override
            public boolean expectResult() {
                return MethodHandlerMatcher.this.hasReturnValue;
            }

            @Override
            public boolean isPassive() {
                return MethodHandlerMatcher.this.passive;
            }

            public String toString() {
                return Optional.ofNullable(MethodHandlerMatcher.this.targetClass).map(c -> {
                    String simpleName = c.getSimpleName();
                    return String.format("\"%s\"", simpleName.isEmpty() ? c : simpleName);
                }).orElse("MethodHandlerInvoker");
            }

            @Generated
            public MethodHandlerInvoker() {
            }
        }
    }
}

