/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.constraints;

import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.api.HasId;
import io.fluxzero.common.api.search.Constraint;
import io.fluxzero.common.api.search.NoOpConstraint;
import io.fluxzero.common.api.search.constraints.AnyConstraint;
import io.fluxzero.common.api.search.constraints.PathConstraint;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class MatchConstraint
extends PathConstraint {
    @NonNull
    private final String match;
    private final List<String> paths;
    private final boolean strict;
    private final AtomicReference<Object> entryMatcher = new AtomicReference();

    public static Constraint match(Object value, String ... paths) {
        return MatchConstraint.match(value, false, paths);
    }

    public static Constraint match(Object value, boolean strict, String ... paths) {
        List<String> filteredPaths = Arrays.stream(paths).filter(p -> p != null && !p.isBlank()).toList();
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, HasId.class}, (Object)object, n)) {
            case 0: {
                Collection objects = (Collection)object;
                List<Constraint> constraints = objects.stream().filter(Objects::nonNull).map(v -> new MatchConstraint(v.toString(), filteredPaths, strict)).collect(Collectors.toList());
                return switch (constraints.size()) {
                    case 0 -> NoOpConstraint.instance;
                    case 1 -> (Constraint)constraints.getFirst();
                    default -> AnyConstraint.any(constraints);
                };
            }
            case 1: {
                HasId id = (HasId)object;
                return new MatchConstraint(id.getId(), filteredPaths, strict);
            }
            case -1: {
                return NoOpConstraint.instance;
            }
        }
        return new MatchConstraint(value.toString(), filteredPaths, strict);
    }

    @Override
    protected boolean matches(Document.Entry entry, Document document) {
        String summary = document.getSummary();
        if (summary != null && !summary.contains(entry.asPhrase())) {
            return false;
        }
        return this.entryMatcher().test(entry);
    }

    protected Predicate<Document.Entry> computeEntryMatcher() {
        if (this.strict) {
            return entry -> entry.getValue().equals(this.match);
        }
        String pattern = SearchUtils.normalize(this.getMatch());
        return entry -> entry.asPhrase().equals(pattern);
    }

    @NonNull
    @Generated
    public String getMatch() {
        return this.match;
    }

    @Override
    @Generated
    public List<String> getPaths() {
        return this.paths;
    }

    @Generated
    public boolean isStrict() {
        return this.strict;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchConstraint)) {
            return false;
        }
        MatchConstraint other = (MatchConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStrict() != other.isStrict()) {
            return false;
        }
        String this$match = this.getMatch();
        String other$match = other.getMatch();
        if (this$match == null ? other$match != null : !this$match.equals(other$match)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MatchConstraint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStrict() ? 79 : 97);
        String $match = this.getMatch();
        result = result * 59 + ($match == null ? 43 : $match.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MatchConstraint(match=" + this.getMatch() + ", paths=" + String.valueOf(this.getPaths()) + ", strict=" + this.isStrict() + ", entryMatcher=" + String.valueOf(this.entryMatcher()) + ")";
    }

    @ConstructorProperties(value={"match", "paths", "strict"})
    @Generated
    private MatchConstraint(@NonNull String match, List<String> paths, boolean strict) {
        if (match == null) {
            throw new NullPointerException("match is marked non-null but is null");
        }
        this.match = match;
        this.paths = paths;
        this.strict = strict;
    }

    @Override
    @Generated
    public MatchConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new MatchConstraint(this.match, paths, this.strict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    protected Predicate<Document.Entry> entryMatcher() {
        Object $value = this.entryMatcher.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.entryMatcher;
            synchronized (atomicReference) {
                $value = this.entryMatcher.get();
                if ($value == null) {
                    Predicate<Document.Entry> actualValue = this.computeEntryMatcher();
                    $value = actualValue == null ? this.entryMatcher : actualValue;
                    this.entryMatcher.set($value);
                }
            }
        }
        return (Predicate)($value == this.entryMatcher ? null : $value);
    }
}

