/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.bulkupdate;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxzero.common.api.search.BulkUpdate;
import io.fluxzero.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class IndexDocument
implements BulkUpdate {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    @NonNull
    private final Object object;
    private final Object id;
    private final Object collection;
    private final Instant timestamp;
    private final Instant end;

    public static IndexDocument fromDocument(SerializedDocument document) {
        return new IndexDocument(document, document.getId(), document.getCollection(), Optional.ofNullable(document.getTimestamp()).map(Instant::ofEpochMilli).orElse(null), Optional.ofNullable(document.getEnd()).map(Instant::ofEpochMilli).orElse(null));
    }

    @Override
    public BulkUpdate.Type getType() {
        return BulkUpdate.Type.index;
    }

    @Generated
    public static IndexDocumentBuilder builder() {
        return new IndexDocumentBuilder();
    }

    @Generated
    public IndexDocumentBuilder toBuilder() {
        return new IndexDocumentBuilder().object(this.object).id(this.id).collection(this.collection).timestamp(this.timestamp).end(this.end);
    }

    @NonNull
    @Generated
    public Object getObject() {
        return this.object;
    }

    @Override
    @Generated
    public Object getId() {
        return this.id;
    }

    @Override
    @Generated
    public Object getCollection() {
        return this.collection;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Instant getEnd() {
        return this.end;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDocument)) {
            return false;
        }
        IndexDocument other = (IndexDocument)o;
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Object this$id = this.getId();
        Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Object this$collection = this.getCollection();
        Object other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Instant this$end = this.getEnd();
        Instant other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Object $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Object $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Instant $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IndexDocument(object=" + String.valueOf(this.getObject()) + ", id=" + String.valueOf(this.getId()) + ", collection=" + String.valueOf(this.getCollection()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }

    @ConstructorProperties(value={"object", "id", "collection", "timestamp", "end"})
    @Generated
    public IndexDocument(@NonNull Object object, Object id, Object collection, Instant timestamp, Instant end) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.object = object;
        this.id = id;
        this.collection = collection;
        this.timestamp = timestamp;
        this.end = end;
    }

    @Generated
    public static class IndexDocumentBuilder {
        @Generated
        private Object object;
        @Generated
        private Object id;
        @Generated
        private Object collection;
        @Generated
        private Instant timestamp;
        @Generated
        private Instant end;

        @Generated
        IndexDocumentBuilder() {
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
        @Generated
        public IndexDocumentBuilder object(@NonNull Object object) {
            if (object == null) {
                throw new NullPointerException("object is marked non-null but is null");
            }
            this.object = object;
            return this;
        }

        @Generated
        public IndexDocumentBuilder id(Object id) {
            this.id = id;
            return this;
        }

        @Generated
        public IndexDocumentBuilder collection(Object collection) {
            this.collection = collection;
            return this;
        }

        @Generated
        public IndexDocumentBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public IndexDocumentBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        @Generated
        public IndexDocument build() {
            return new IndexDocument(this.object, this.id, this.collection, this.timestamp, this.end);
        }

        @Generated
        public String toString() {
            return "IndexDocument.IndexDocumentBuilder(object=" + String.valueOf(this.object) + ", id=" + String.valueOf(this.id) + ", collection=" + String.valueOf(this.collection) + ", timestamp=" + String.valueOf(this.timestamp) + ", end=" + String.valueOf(this.end) + ")";
        }
    }
}

