/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.reflection;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.reflection.DefaultMemberInvoker;
import io.fluxzero.common.reflection.GenericTypeResolver;
import io.fluxzero.common.reflection.KotlinReflectionUtils;
import io.fluxzero.common.serialization.DefaultTypeRegistry;
import io.fluxzero.common.serialization.JsonUtils;
import io.fluxzero.common.serialization.TypeRegistry;
import java.beans.ConstructorProperties;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.reflect.KParameter;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ReflectionUtils {
    private static final int ACCESS_MODIFIERS = 7;
    private static final List<Integer> ACCESS_ORDER = List.of(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(1));
    private static final Function<Class<?>, List<Method>> methodsCache = ObjectUtils.memoize(ReflectionUtils::computeAllMethods);
    private static final Function<String, Optional<Class<?>>> classForFqnCache = ObjectUtils.memoize(ReflectionUtils::computeClassForFqn);
    private static final Supplier<TypeRegistry> typeRegistrySupplier = ObjectUtils.memoize(() -> new DefaultTypeRegistry());
    private static final Function<String, Optional<Class<?>>> classForNameCache = ObjectUtils.memoize(ReflectionUtils::computeClassForName);
    private static final BiFunction<Class<?>, Class<? extends Annotation>, List<? extends AccessibleObject>> annotatedPropertiesCache = ObjectUtils.memoize(ReflectionUtils::computeAnnotatedProperties);
    private static final BiFunction<Class<?>, String, Function<Object, Object>> gettersCache = ObjectUtils.memoize(ReflectionUtils::computeNestedGetter);
    private static final BiFunction<String, Class<?>, BiConsumer<Object, Object>> settersCache = ObjectUtils.memoize(ReflectionUtils::computeNestedSetter);
    private static final Function<Parameter, Boolean> isNullableCache = ObjectUtils.memoize(parameter -> ReflectionUtils.getParameterOverrideHierarchy(parameter).anyMatch(p -> {
        KParameter kotlinParameter;
        if (ReflectionUtils.isKotlinReflectionSupported() && (kotlinParameter = KotlinReflectionUtils.asKotlinParameter(p)) != null && kotlinParameter.getType().isMarkedNullable()) {
            return true;
        }
        return Arrays.stream(p.getAnnotations()).anyMatch(a -> a.annotationType().getSimpleName().equals("Nullable"));
    }));
    private static final Function<Class<?>, Collection<? extends Annotation>> typeAnnotations = ObjectUtils.memoize(ReflectionUtils::computeTypeAnnotations);
    private static final Comparator<Class<?>> classSpecificityComparator = (o1, o2) -> Objects.equals(o1, o2) ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : (o1.isAssignableFrom((Class<?>)o2) ? 1 : (o2.isAssignableFrom((Class<?>)o1) ? -1 : (o1.isInterface() && !o2.isInterface() ? 1 : (!o1.isInterface() && o2.isInterface() ? -1 : ReflectionUtils.specificity(o2) - ReflectionUtils.specificity(o1)))))));
    private static final Set<Class<?>> leafValueTypes = Set.of(String.class, Number.class, Boolean.class, Character.class, UUID.class, URI.class, URL.class, Locale.class, Currency.class, Temporal.class, TemporalAmount.class);

    static int specificity(Class<?> type) {
        int depth = 0;
        if (type.isInterface()) {
            while (t.getInterfaces().length > 0) {
                ++depth;
                t = t.getInterfaces()[0];
            }
        } else {
            for (t = type; t != null; t = t.getSuperclass()) {
                ++depth;
            }
        }
        return depth;
    }

    public static Stream<Method> getMethodOverrideHierarchy(Method method) {
        return MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).stream();
    }

    public static Stream<Parameter> getParameterOverrideHierarchy(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return ReflectionUtils.getMethodOverrideHierarchy(method).flatMap(m -> Arrays.stream(m.getParameters()).filter(p -> p.getName().equals(parameter.getName())));
        }
        return Stream.of(parameter);
    }

    public static boolean isKotlinReflectionSupported() {
        return ReflectionUtils.classExists("kotlin.reflect.full.KClasses");
    }

    public static Class<?> ifClass(Object value) {
        if (value instanceof Class) {
            Class c = (Class)value;
            return c;
        }
        if (ReflectionUtils.isKotlinReflectionSupported()) {
            return KotlinReflectionUtils.convertIfKotlinClass(value);
        }
        return null;
    }

    public static Class<?> asClass(@NonNull Object value) {
        Class<?> clazz;
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Class<?> clazz2 = ReflectionUtils.ifClass(value);
        if (clazz2 instanceof Class) {
            Class<?> c = clazz2;
            clazz = c;
        } else {
            clazz = value.getClass();
        }
        return clazz;
    }

    public static List<Method> getAllMethods(Class<?> type) {
        return methodsCache.apply(type);
    }

    public static Optional<Method> getMethod(Class<?> type, String name) {
        for (Method method : ReflectionUtils.getAllMethods(type)) {
            if (!name.equals(method.getName())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private static List<Method> computeAllMethods(Class<?> type) {
        Predicate<Method> include = m -> !m.isBridge() && !m.isSynthetic() && Character.isJavaIdentifierStart(m.getName().charAt(0)) && m.getName().chars().skip(1L).allMatch(Character::isJavaIdentifierPart);
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Collections.addAll(methods, type.getMethods());
        methods.removeIf(include.negate());
        Stream.of(type.getDeclaredMethods()).filter(include).forEach(methods::add);
        int access = 7;
        Package p = type.getPackage();
        HashMap<Object, Set> types = new HashMap<Object, Set>();
        Set pkgIndependent = Collections.emptySet();
        for (Method m2 : methods) {
            int acc = m2.getModifiers() & 7;
            if (acc == 2) continue;
            if (acc != 0) {
                types.put(ReflectionUtils.methodKey(m2), pkgIndependent);
                continue;
            }
            types.computeIfAbsent(ReflectionUtils.methodKey(m2), x -> new HashSet()).add(p);
        }
        include = include.and(m -> {
            int acc = m.getModifiers() & 7;
            return acc != 0 ? acc == 2 || types.putIfAbsent(ReflectionUtils.methodKey(m), pkgIndependent) == null : ReflectionUtils.noPkgOverride(m, types, pkgIndependent);
        });
        for (type = type.getSuperclass(); type != null; type = type.getSuperclass()) {
            Stream.of(type.getDeclaredMethods()).filter(include).forEach(methods::add);
        }
        return new ArrayList<Method>(methods);
    }

    private static boolean noPkgOverride(Method m, Map<Object, Set<Package>> types, Set<Package> pkgIndependent) {
        Set pkg = types.computeIfAbsent(ReflectionUtils.methodKey(m), key -> new HashSet());
        return pkg != pkgIndependent && pkg.add(m.getDeclaringClass().getPackage());
    }

    private static Object methodKey(Method m) {
        return Arrays.asList(m.getName(), MethodType.methodType(m.getReturnType(), m.getParameterTypes()));
    }

    public static List<? extends AccessibleObject> getAnnotatedProperties(Class<?> target, Class<? extends Annotation> annotation) {
        return annotatedPropertiesCache.apply(target, annotation);
    }

    private static List<? extends AccessibleObject> computeAnnotatedProperties(Class<?> target, Class<? extends Annotation> annotation) {
        ArrayList<Method> result = new ArrayList<Method>(FieldUtils.getFieldsListWithAnnotation(target, annotation));
        result.addAll(MethodUtils.getMethodsListWithAnnotation(target, annotation, (boolean)true, (boolean)true).stream().filter(m -> m.getParameterCount() == 0).filter(m -> !m.getDeclaringClass().isAssignableFrom(m.getReturnType())).toList());
        ClassUtils.getAllInterfaces(target).forEach(i -> result.addAll(FieldUtils.getFieldsListWithAnnotation((Class)i, (Class)annotation)));
        result.forEach(ReflectionUtils::ensureAccessible);
        return result;
    }

    public static Optional<? extends AccessibleObject> getAnnotatedProperty(Object target, Class<? extends Annotation> annotation) {
        return target == null ? Optional.empty() : ReflectionUtils.getAnnotatedProperty(ReflectionUtils.asClass(target), annotation);
    }

    public static Optional<? extends AccessibleObject> getAnnotatedProperty(Class<?> target, Class<? extends Annotation> annotation) {
        List<? extends AccessibleObject> annotatedProperties = ReflectionUtils.getAnnotatedProperties(target, annotation);
        return annotatedProperties.isEmpty() ? Optional.empty() : Optional.of(annotatedProperties.getFirst());
    }

    public static Optional<Object> getAnnotatedPropertyValue(Object target, Class<? extends Annotation> annotation) {
        return ReflectionUtils.getAnnotatedProperty(target, annotation).map(m -> ReflectionUtils.getValue(m, target, false));
    }

    public static Collection<Object> getAnnotatedPropertyValues(Object target, Class<? extends Annotation> annotation) {
        if (target == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (AccessibleObject accessibleObject : ReflectionUtils.getAnnotatedProperties(target.getClass(), annotation)) {
            Object value = ReflectionUtils.getValue(accessibleObject, target, false);
            if (value == null) continue;
            results.add(value);
        }
        return results;
    }

    public static Optional<String> getAnnotatedPropertyName(Object target, Class<? extends Annotation> annotation) {
        return ReflectionUtils.getAnnotatedProperty(target, annotation).map(ReflectionUtils::getPropertyName);
    }

    public static String getPropertyName(AccessibleObject property) {
        if (property instanceof Field) {
            Field field = (Field)property;
            return field.getName();
        }
        if (property instanceof Method) {
            Method method = (Method)property;
            String name = method.getName();
            if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                char[] c = name.toCharArray();
                c[3] = Character.toLowerCase(c[3]);
                name = String.valueOf(c, 3, c.length - 3);
            } else if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
                char[] c = name.toCharArray();
                c[2] = Character.toLowerCase(c[2]);
                name = String.valueOf(c, 2, c.length - 2);
            }
            return name;
        }
        throw new UnsupportedOperationException("Not a property: " + String.valueOf(property));
    }

    public static List<Method> getAnnotatedMethods(Class<?> target, Class<? extends Annotation> annotation) {
        return methodsCache.apply(target).stream().filter(m -> ReflectionUtils.getMethodAnnotation(m, annotation).isPresent()).toList();
    }

    public static List<Method> getAnnotatedMethods(Object target, Class<? extends Annotation> annotation) {
        return target == null ? List.of() : ReflectionUtils.getAnnotatedMethods(target.getClass(), annotation);
    }

    public static boolean isMethodAnnotationPresent(Class<?> target, Class<? extends Annotation> annotation) {
        for (Method method : methodsCache.apply(target)) {
            if (!ReflectionUtils.getMethodAnnotation(method, annotation).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAnnotatedFields(Class<?> target, Class<? extends Annotation> annotation) {
        return FieldUtils.getAllFieldsList(target).stream().filter(f -> ReflectionUtils.getFieldAnnotation(f, annotation).isPresent()).toList();
    }

    public static List<Field> getAnnotatedFields(Object target, Class<? extends Annotation> annotation) {
        return target == null ? Collections.emptyList() : ReflectionUtils.getAnnotatedFields(ReflectionUtils.asClass(target), annotation);
    }

    public static boolean isAnnotationPresent(Class<?> type, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.getTypeAnnotation(type, annotationType) != null;
    }

    public static <A extends Annotation> A getTypeAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        if (type == null) {
            return null;
        }
        for (Annotation annotation : ReflectionUtils.getTypeAnnotations(type)) {
            if (annotation.annotationType().equals(annotationType)) {
                return (A)annotation;
            }
            for (Annotation annotation2 : ReflectionUtils.getTypeAnnotations(annotation.annotationType())) {
                if (!annotation2.annotationType().equals(annotationType)) continue;
                return (A)annotation;
            }
        }
        return ReflectionUtils.getTypeAnnotation(type.getEnclosingClass(), annotationType);
    }

    public static Collection<? extends Annotation> getTypeAnnotations(Class<?> type) {
        return typeAnnotations.apply(type);
    }

    private static Collection<? extends Annotation> computeTypeAnnotations(Class<?> type) {
        return Stream.concat(Arrays.stream(type.getAnnotations()), ClassUtils.getAllInterfaces(type).stream().flatMap(iType -> Arrays.stream(iType.getAnnotations()))).filter(ObjectUtils.distinctByKey(Annotation::annotationType)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static <A extends Annotation> Optional<A> getPackageAnnotation(Package p, Class<A> annotationType) {
        return ReflectionUtils.getPackageAnnotations(p).stream().filter(a -> a.annotationType().equals(annotationType)).map(a -> a).findFirst();
    }

    public static Collection<? extends Annotation> getPackageAnnotations(Package p) {
        return ReflectionUtils.getPackageAnnotations(p, true);
    }

    public static Collection<? extends Annotation> getPackageAnnotations(Package p, boolean recursive) {
        if (p == null) {
            return Collections.emptyList();
        }
        Stream<Annotation> stream = Arrays.stream(p.getAnnotations());
        if (recursive) {
            stream = Stream.concat(stream, ReflectionUtils.getPackageAnnotations(ReflectionUtils.getFirstKnownAncestorPackage(p.getName()), true).stream());
            return stream.collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a, b) -> a, LinkedHashMap::new)).values();
        }
        return stream.toList();
    }

    public static <T> Optional<T> readProperty(String propertyPath, Object target) {
        if (target == null) {
            return Optional.empty();
        }
        if (propertyPath == null || propertyPath.isBlank()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(gettersCache.apply(target.getClass(), propertyPath).apply(target)).map(v -> v);
        }
        catch (PropertyNotFoundException ignored) {
            return Optional.empty();
        }
    }

    public static List<Type> getTypeArguments(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return Arrays.asList(pt.getActualTypeArguments());
        }
        return Collections.emptyList();
    }

    public static <T extends Type> T getFirstTypeArgument(Type genericType) {
        return ReflectionUtils.getTypeArgument(genericType, 0);
    }

    public static <T extends Type> T getTypeArgument(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (T)pt.getActualTypeArguments()[index];
        }
        throw new IllegalArgumentException("Type is raw and does not define arguments");
    }

    public static <T> Optional<T> getPropertyAnnotation(String propertyPath, Object target) {
        if (target == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(gettersCache.apply(target.getClass(), propertyPath).apply(target)).map(v -> v);
        }
        catch (PropertyNotFoundException ignored) {
            return Optional.empty();
        }
    }

    public static boolean hasProperty(String propertyPath, Object target) {
        if (target == null || propertyPath == null) {
            return false;
        }
        try {
            gettersCache.apply(target.getClass(), propertyPath).apply(target);
            return true;
        }
        catch (PropertyNotFoundException ignored) {
            return false;
        }
    }

    private static Function<Object, Object> computeNestedGetter(Class<?> type, String propertyPath) {
        String[] parts = (String[])Arrays.stream(propertyPath.replace('.', '/').split("/")).filter(s -> !s.isBlank()).toArray(String[]::new);
        if (parts.length == 1) {
            return ReflectionUtils.computeGetter(type, parts[0]);
        }
        return object -> {
            for (String part : parts) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Collection) {
                    Collection collection = object;
                    object = collection.stream().flatMap(o -> {
                        Stream<Object> stream;
                        Object apply = ReflectionUtils.computeNestedGetter(o.getClass(), part).apply(o);
                        if (apply instanceof Collection) {
                            Collection c = (Collection)apply;
                            stream = c.stream();
                        } else {
                            stream = Stream.of(apply);
                        }
                        return stream;
                    }).collect(Collectors.toList());
                    continue;
                }
                object = ReflectionUtils.computeNestedGetter(object.getClass(), part).apply(object);
            }
            return object;
        };
    }

    private static Function<Object, Object> computeGetter(@NonNull Class<?> type, @NonNull String propertyName) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (ObjectNode.class.isAssignableFrom(type)) {
            return target -> ((ObjectNode)target).get(propertyName);
        }
        if (Map.class.isAssignableFrom(type)) {
            return target -> ((Map)target).get(propertyName);
        }
        PropertyNotFoundException notFoundException = new PropertyNotFoundException(propertyName, type);
        return ReflectionUtils.getMethod(type, "get" + StringUtils.capitalize((String)propertyName)).map(m -> m).or(() -> ReflectionUtils.getMethod(type, propertyName)).or(() -> ReflectionUtils.getField(type, propertyName)).map(DefaultMemberInvoker::asInvoker).map(invoker -> invoker::invoke).orElseGet(() -> o -> {
            throw notFoundException;
        });
    }

    public static <T> Optional<T> getFieldValue(String fieldName, Object target) {
        return target == null ? Optional.empty() : ReflectionUtils.getField(ReflectionUtils.asClass(target), fieldName).map(f -> ReflectionUtils.getValue(f, target, true));
    }

    public static Object getValue(AccessibleObject fieldOrMethod, Object target, boolean forceAccess) {
        if (fieldOrMethod instanceof Method) {
            return DefaultMemberInvoker.asInvoker((Method)fieldOrMethod, forceAccess).invoke(target);
        }
        if (fieldOrMethod instanceof Field) {
            return DefaultMemberInvoker.asInvoker((Field)fieldOrMethod, forceAccess).invoke(target);
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static Object getValue(AccessibleObject fieldOrMethod, Object target) {
        return ReflectionUtils.getValue(fieldOrMethod, target, true);
    }

    public static String getName(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Member) {
            return ((Member)((Object)fieldOrMethod)).getName();
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static Class<?> getEnclosingClass(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Member) {
            return ((Member)((Object)fieldOrMethod)).getDeclaringClass();
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static Class<?> getPropertyType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ((Method)fieldOrMethod).getReturnType();
        }
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getType();
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static Type getGenericPropertyType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ((Method)fieldOrMethod).getGenericReturnType();
        }
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getGenericType();
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static void writeProperty(String propertyPath, Object target, Object value) {
        if (target != null) {
            try {
                settersCache.apply(propertyPath, target.getClass()).accept(target, value);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
    }

    private static BiConsumer<Object, Object> computeNestedSetter(@NonNull String propertyPath, @NonNull Class<?> type) {
        if (propertyPath == null) {
            throw new NullPointerException("propertyPath is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String[] parts = (String[])Arrays.stream(propertyPath.replace('.', '/').split("/")).filter(s -> !s.isBlank()).toArray(String[]::new);
        if (parts.length == 1) {
            return ReflectionUtils.computeSetter(parts[0], type);
        }
        Function<Object, Object> parentSupplier = gettersCache.apply(type, Arrays.stream(parts).limit(parts.length - 1).collect(Collectors.joining("/")));
        return (object, value) -> {
            Object parent = parentSupplier.apply(object);
            if (parent != null) {
                BiConsumer<Object, Object> setter = settersCache.apply(parts[parts.length - 1], parent.getClass());
                setter.accept(parent, value);
            }
        };
    }

    private static BiConsumer<Object, Object> computeSetter(@NonNull String propertyName, @NonNull Class<?> type) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (ObjectNode.class.isAssignableFrom(type)) {
            return (target, propertyValue) -> ((ObjectNode)target).putPOJO(propertyName, propertyValue);
        }
        PropertyNotFoundException notFoundException = new PropertyNotFoundException(propertyName, type);
        return Arrays.stream(Introspector.getBeanInfo(type, null).getPropertyDescriptors()).filter(d -> propertyName.equals(d.getName())).map(PropertyDescriptor::getWriteMethod).filter(Objects::nonNull).findFirst().or(() -> Optional.ofNullable(FieldUtils.getField((Class)type, (String)propertyName, (boolean)true))).map(DefaultMemberInvoker::asInvoker).map(invoker -> invoker::invoke).orElseGet(() -> (t, v) -> {
            throw notFoundException;
        });
    }

    private static void setValue(Member fieldOrMethod, Object target, Object value) {
        DefaultMemberInvoker.asInvoker(fieldOrMethod).invoke(target, value);
    }

    public static boolean isOrHas(Annotation annotation, Class<? extends Annotation> annotationType) {
        return annotation != null && (Objects.equals(annotation.annotationType(), annotationType) || annotation.annotationType().isAnnotationPresent(annotationType));
    }

    public static Optional<Field> getField(Class<?> owner, String name) {
        while (owner != null) {
            for (Field declaredField : owner.getDeclaredFields()) {
                if (!declaredField.getName().equals(name)) continue;
                return Optional.of(declaredField);
            }
            owner = owner.getSuperclass();
        }
        return Optional.empty();
    }

    public static Class<?> getCallerClass() {
        return StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE)).walk(s -> {
            Iterator iterator = s.skip(1L).iterator();
            Class<?> invoker = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
            while (iterator.hasNext()) {
                StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator.next();
                Class<?> frameClass = frame.getDeclaringClass();
                if (frameClass.equals(invoker) || frameClass.getName().startsWith("java.")) continue;
                return frameClass;
            }
            return null;
        });
    }

    public static boolean isNullable(Parameter parameter) {
        return isNullableCache.apply(parameter);
    }

    public static <T> T asInstance(Object classOrInstance) {
        Class<?> clazz = ReflectionUtils.ifClass(classOrInstance);
        if (clazz instanceof Class) {
            Class<?> c = clazz;
            try {
                return (T)ReflectionUtils.ensureAccessible(c.getDeclaredConstructor(new Class[0])).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to create an instance of class %s. Does it have an accessible default constructor?", classOrInstance), e);
            }
        }
        return (T)classOrInstance;
    }

    public static int getParameterIndex(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        for (int i = 0; i < executable.getParameters().length; ++i) {
            if (!executable.getParameters()[i].equals(parameter)) continue;
            return i;
        }
        throw new IllegalStateException("Could not get parameter index of " + String.valueOf(parameter));
    }

    public static List<Class<?>> determineCommonAncestors(Collection<?> elements) {
        return ReflectionUtils.determineCommonAncestors((Class[])elements.stream().map(e -> e == null ? Void.class : e.getClass()).distinct().toArray(Class[]::new));
    }

    static List<Class<?>> determineCommonAncestors(Class<?> ... classes) {
        return switch (classes.length) {
            case 0 -> Collections.emptyList();
            case 1 -> List.of(classes);
            default -> {
                LinkedHashSet rollingIntersect = new LinkedHashSet(ReflectionUtils.getClassHierarchy(classes[0]));
                for (int i = 1; i < classes.length; ++i) {
                    rollingIntersect.retainAll(ReflectionUtils.getClassHierarchy(classes[i]));
                }
                if (rollingIntersect.isEmpty()) {
                    yield List.of(Object.class);
                }
                yield new LinkedList(rollingIntersect);
            }
        };
    }

    static Set<Class<?>> getClassHierarchy(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                Collections.addAll(nextLevel, each.getInterfaces());
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }

    public static List<Package> getPackageAndParentPackages(Package p) {
        ArrayList<Package> result = new ArrayList<Package>();
        while (p != null) {
            result.add(p);
            p = ReflectionUtils.getFirstKnownAncestorPackage(p.getName());
        }
        return result;
    }

    static Package getFirstKnownAncestorPackage(String childPackageName) {
        String parentName = ReflectionUtils.getParentPackageName(childPackageName);
        while (parentName != null) {
            Package result = ReflectionUtils.tryGetPackage(parentName);
            if (result != null) {
                return result;
            }
            parentName = ReflectionUtils.getParentPackageName(parentName);
        }
        return null;
    }

    static String getParentPackageName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return lastIndex < 0 ? null : name.substring(0, lastIndex);
    }

    private static Package tryGetPackage(String name) {
        Package definedPackage = ReflectionUtils.class.getClassLoader().getDefinedPackage(name);
        if (definedPackage != null) {
            return definedPackage;
        }
        String packagePath = name.replace('.', '/');
        URL resource = ReflectionUtils.class.getClassLoader().getResource(packagePath);
        if (resource == null) {
            return null;
        }
        File packageDir = new File(resource.getFile());
        if (packageDir.exists() && packageDir.isDirectory() && new File(resource.getFile() + "/package-info.class").exists()) {
            try {
                Class<?> result = ReflectionUtils.classForName(name + ".package-info");
                if (result != null) {
                    return result.getPackage();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <A extends Annotation> Optional<A> getMemberAnnotation(Class<?> type, String memberName, Class<? extends Annotation> a) {
        return ReflectionUtils.getAnnotatedMethods(type, a).stream().filter(m -> m.getName().equals(memberName)).findFirst().flatMap(m -> ReflectionUtils.getMethodAnnotation(m, a)).or(() -> {
            String alias = memberName.startsWith("get") ? memberName.substring(3) : (memberName.startsWith("is") ? memberName.substring(2) : memberName);
            return ReflectionUtils.getAnnotatedFields(type, a).stream().filter(f -> f.getName().equalsIgnoreCase(memberName) || f.getName().equalsIgnoreCase(alias)).findFirst().flatMap(f -> ReflectionUtils.getFieldAnnotation(f, a));
        });
    }

    public static boolean isStatic(Executable method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isLeafValue(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> type = value.getClass();
        return leafValueTypes.stream().anyMatch(t -> t.isAssignableFrom(type)) || type.isEnum();
    }

    public static boolean isAnnotationPresent(Parameter parameter, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.getAnnotation(parameter, annotationType).isPresent();
    }

    public static Type getGenericType(Class<?> candidate, Class<?> wantedClass) {
        return GenericTypeResolver.getGenericType(candidate, wantedClass);
    }

    public static Optional<Class<?>> getCollectionElementType(AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method) {
            return ReflectionUtils.getCollectionElementType(((Method)fieldOrMethod).getGenericReturnType());
        }
        if (fieldOrMethod instanceof Field) {
            return ReflectionUtils.getCollectionElementType(((Field)fieldOrMethod).getGenericType());
        }
        throw new IllegalStateException("Object property should be field or method: " + String.valueOf(fieldOrMethod));
    }

    public static Optional<Class<?>> getCollectionElementType(Type parameterizedType) {
        if (parameterizedType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)parameterizedType).getRawType();
            Type elementType = rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType) ? ((ParameterizedType)parameterizedType).getActualTypeArguments()[1] : ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            if (elementType instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)elementType).getUpperBounds();
                elementType = upperBounds.length > 0 ? upperBounds[0] : null;
            }
            return Optional.of(elementType instanceof Class ? (Class)elementType : Object.class);
        }
        return Optional.empty();
    }

    public static boolean declaresField(Class<?> target, String fieldName) {
        return !StringUtils.isEmpty((CharSequence)fieldName) && FieldUtils.getDeclaredField(target, (String)fieldName, (boolean)true) != null;
    }

    public static void setField(Field field, Object target, Object value) {
        ReflectionUtils.ensureAccessible(field).set(target, value);
    }

    public static void setField(String fieldName, Object target, Object value) {
        ReflectionUtils.setField(target.getClass().getDeclaredField(fieldName), target, value);
    }

    public static <T extends AccessibleObject> T ensureAccessible(T member) {
        member.setAccessible(true);
        return member;
    }

    public static <A extends Annotation> Optional<A> getAnnotation(AnnotatedElement m, Class<A> a) {
        return ReflectionUtils.getAnnotationAs(m, a, a);
    }

    public static <T> Optional<T> getAnnotationAs(Class<?> target, Class<? extends Annotation> annotationType, Class<T> returnType) {
        return ReflectionUtils.getAnnotationAs(ReflectionUtils.getTypeAnnotation(target, annotationType), annotationType, returnType);
    }

    public static <T> Optional<T> getAnnotationAs(AnnotatedElement member, Class<? extends Annotation> annotationType, Class<? extends T> returnType) {
        AnnotatedElement annotatedElement = member;
        Objects.requireNonNull(annotatedElement);
        AnnotatedElement annotatedElement2 = annotatedElement;
        int n = 0;
        Object annotation = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Executable.class, Package.class, Class.class}, (Object)annotatedElement2, n)) {
            case 0 -> {
                Executable e = (Executable)annotatedElement2;
                yield ReflectionUtils.getMethodAnnotation(e, annotationType).orElse(null);
            }
            case 1 -> {
                Package p = (Package)annotatedElement2;
                yield ReflectionUtils.getPackageAnnotation(p, annotationType).orElse(null);
            }
            case 2 -> {
                Class c = (Class)annotatedElement2;
                yield ReflectionUtils.getTypeAnnotation(c, annotationType);
            }
            default -> ReflectionUtils.getTopLevelAnnotation(member, annotationType);
        };
        return ReflectionUtils.getAnnotationAs(annotation, annotationType, returnType);
    }

    public static <T> Optional<T> getAnnotationAs(Annotation annotation, Class<? extends Annotation> targetAnnotation, Class<? extends T> returnType) {
        if (targetAnnotation == null) {
            return Optional.empty();
        }
        if (annotation == null) {
            return Optional.empty();
        }
        if (targetAnnotation.equals(returnType)) {
            if (annotation.annotationType().equals(returnType)) {
                return Optional.of(annotation);
            }
            return Optional.of(annotation.annotationType().getAnnotation(targetAnnotation));
        }
        Class<? extends Annotation> matchedType = annotation.annotationType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!matchedType.equals(targetAnnotation)) {
            Annotation typeAnnotation = matchedType.getAnnotation(targetAnnotation);
            Method[] methodArray = targetAnnotation.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                params.put(method.getName(), method.invoke((Object)typeAnnotation, new Object[0]));
            }
        }
        for (Method method : matchedType.getDeclaredMethods()) {
            params.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
        }
        if (Map.class.equals(returnType)) {
            return Optional.of(params);
        }
        return Optional.of(JsonUtils.convertValue(params, returnType));
    }

    public static <T> T convertAnnotation(Annotation annotation, Class<? extends T> returnType) {
        return ReflectionUtils.getAnnotationAs(annotation, annotation.annotationType(), returnType).orElseThrow();
    }

    public static boolean has(Class<? extends Annotation> annotationClass, Method method) {
        return ReflectionUtils.getMethodAnnotation(method, annotationClass).isPresent();
    }

    public static boolean has(Class<? extends Annotation> annotationClass, Parameter parameter) {
        for (Annotation annotation : parameter.getAnnotations()) {
            if (!ReflectionUtils.isOrHas(annotation, annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> Optional<A> getFieldAnnotation(Field f, Class<? extends Annotation> a) {
        return Optional.ofNullable(f.getAnnotation(a)).or(() -> Arrays.stream(f.getAnnotations()).filter(metaAnnotation -> metaAnnotation.annotationType().isAnnotationPresent(a)).findFirst().map(hit -> hit));
    }

    public static <A extends Annotation> Optional<A> getMethodAnnotation(Executable m, Class<? extends Annotation> a) {
        A result;
        block3: {
            result = ReflectionUtils.getTopLevelAnnotation(m, a);
            Class<?> c = m.getDeclaringClass();
            if (result != null) break block3;
            Class<?> s = c;
            while (result == null && (s = s.getSuperclass()) != null) {
                result = ReflectionUtils.getAnnotationOnSuper(m, s, a);
            }
            if (result == null && m instanceof Method) {
                Class s2;
                Iterator iterator = ClassUtils.getAllInterfaces(c).iterator();
                while (iterator.hasNext() && (result = ReflectionUtils.getAnnotationOnSuper(m, s2 = (Class)iterator.next(), a)) == null) {
                }
            }
        }
        return Optional.ofNullable(result);
    }

    public static <A extends Annotation> List<A> getMethodAnnotations(Executable m, Class<? extends Annotation> a) {
        List<A> result;
        block3: {
            result = ReflectionUtils.getTopLevelAnnotations(m, a);
            Class<?> c = m.getDeclaringClass();
            if (!result.isEmpty()) break block3;
            Class<?> s = c;
            while (result.isEmpty() && (s = s.getSuperclass()) != null) {
                result = ReflectionUtils.getAnnotationsOnSuper(m, s, a);
            }
            if (result.isEmpty() && m instanceof Method) {
                Class s2;
                Iterator iterator = ClassUtils.getAllInterfaces(c).iterator();
                while (iterator.hasNext() && (result = ReflectionUtils.getAnnotationsOnSuper(m, s2 = (Class)iterator.next(), a)) == null) {
                }
            }
        }
        return result;
    }

    private static <A extends Annotation> A getTopLevelAnnotation(AnnotatedElement m, Class<? extends Annotation> a) {
        return (A)Optional.ofNullable(m.getAnnotation(a)).orElseGet(() -> Arrays.stream(m.getAnnotations()).filter(metaAnnotation -> metaAnnotation.annotationType().isAnnotationPresent(a)).findFirst().orElse(null));
    }

    private static <A extends Annotation> List<A> getTopLevelAnnotations(AnnotatedElement m, Class<? extends Annotation> a) {
        return Optional.ofNullable(m.getAnnotation(a)).map(v -> Stream.of(v)).orElseGet(() -> Arrays.stream(m.getAnnotations()).filter(metaAnnotation -> metaAnnotation.annotationType().isAnnotationPresent(a)).map(v -> v)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static <A extends Annotation> A getAnnotationOnSuper(Executable m, Class<?> s, Class<? extends Annotation> a) {
        try {
            for (Method n : s.getDeclaredMethods()) {
                if (!n.getName().equals(m.getName()) || n.getParameterCount() != m.getParameterCount()) continue;
                n = s.getDeclaredMethod(m.getName(), m.getParameterTypes());
                return ReflectionUtils.overrides(m, n) ? (A)ReflectionUtils.getTopLevelAnnotation(n, a) : null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static <A extends Annotation> List<A> getAnnotationsOnSuper(Executable m, Class<?> s, Class<? extends Annotation> a) {
        try {
            for (Method n : s.getDeclaredMethods()) {
                if (!n.getName().equals(m.getName()) || n.getParameterCount() != m.getParameterCount()) continue;
                n = s.getDeclaredMethod(m.getName(), m.getParameterTypes());
                return ReflectionUtils.overrides(m, n) ? ReflectionUtils.getTopLevelAnnotations(n, a) : Collections.emptyList();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static boolean overrides(Executable a, Executable b) {
        int modsA = a.getModifiers();
        int modsB = b.getModifiers();
        if (Modifier.isPrivate(modsA) || Modifier.isPrivate(modsB)) {
            return false;
        }
        if (Modifier.isStatic(modsA) || Modifier.isStatic(modsB)) {
            return false;
        }
        if (Modifier.isFinal(modsB)) {
            return false;
        }
        if (ReflectionUtils.compareAccess(modsA, modsB) < 0) {
            return false;
        }
        return ReflectionUtils.notPackageAccess(modsA) && ReflectionUtils.notPackageAccess(modsB) || a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private static boolean notPackageAccess(int mods) {
        return (mods & 7) != 0;
    }

    private static int compareAccess(int lhs, int rhs) {
        return Integer.compare(ACCESS_ORDER.indexOf(lhs & 7), ACCESS_ORDER.indexOf(rhs & 7));
    }

    public static <V> V copyFields(V source, V target) {
        if (target == null || source == null) {
            return target;
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new IllegalArgumentException("Source and target class should be equal");
        }
        Class<?> type = source.getClass();
        if (type.isPrimitive() || type.isArray()) {
            return source;
        }
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                ReflectionUtils.ensureAccessible(field).set(target, field.get(source));
            }
            type = type.getSuperclass();
        }
        return target;
    }

    public static Class<?> classForName(String type) {
        Optional<Class<?>> result = classForNameCache.apply(type);
        if (result.isPresent()) {
            return result.get();
        }
        throw new ClassNotFoundException(type);
    }

    public static Class<?> classForName(String type, Class<?> defaultClass) {
        return classForNameCache.apply(type).orElse(defaultClass);
    }

    public static boolean classExists(String className) {
        return classForNameCache.apply(className).isPresent();
    }

    public static String getSimpleName(Class<?> c) {
        return ReflectionUtils.getSimpleName(c.getName());
    }

    public static String getSimpleName(Package p) {
        return p.getName().substring(p.getName().lastIndexOf(46) + 1);
    }

    public static String getSimpleName(String fullyQualifiedName) {
        if (fullyQualifiedName == null || fullyQualifiedName.trim().isEmpty()) {
            throw new IllegalArgumentException("Fully qualified name cannot be null or empty");
        }
        int lastSeparatorIndex = Math.max(fullyQualifiedName.lastIndexOf(46), fullyQualifiedName.lastIndexOf(36));
        return lastSeparatorIndex == -1 ? fullyQualifiedName : fullyQualifiedName.substring(lastSeparatorIndex + 1);
    }

    private static Optional<Class<?>> computeClassForFqn(String type) {
        try {
            return Optional.of(Class.forName(type.split("<")[0]));
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }

    private static Optional<Class<?>> computeClassForName(String name) {
        Optional<Class<?>> fqnResult = classForFqnCache.apply(name);
        if (fqnResult.isPresent()) {
            return fqnResult;
        }
        return typeRegistrySupplier.get().getTypeName(name).flatMap(classForFqnCache);
    }

    @Generated
    public static Comparator<Class<?>> getClassSpecificityComparator() {
        return classSpecificityComparator;
    }

    private static final class PropertyNotFoundException
    extends RuntimeException {
        @NonNull
        private final String propertyName;
        @NonNull
        private final Class<?> type;

        @ConstructorProperties(value={"propertyName", "type"})
        @Generated
        public PropertyNotFoundException(@NonNull String propertyName, @NonNull Class<?> type) {
            if (propertyName == null) {
                throw new NullPointerException("propertyName is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.propertyName = propertyName;
            this.type = type;
        }

        @NonNull
        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @NonNull
        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyNotFoundException)) {
                return false;
            }
            PropertyNotFoundException other = (PropertyNotFoundException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PropertyNotFoundException;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "ReflectionUtils.PropertyNotFoundException(propertyName=" + this.getPropertyName() + ", type=" + String.valueOf(this.getType()) + ")";
        }
    }
}

