/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.handling;

import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.ThrowingRunnable;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import lombok.Generated;

public interface HandlerInvoker {
    public static HandlerInvoker noOp() {
        return SimpleInvoker.noOpInvoker;
    }

    public static HandlerInvoker run(ThrowingRunnable task) {
        return new SimpleInvoker(ObjectUtils.asCallable(task));
    }

    public static HandlerInvoker call(Callable<?> task) {
        return new SimpleInvoker(task);
    }

    public static Optional<HandlerInvoker> join(final List<? extends HandlerInvoker> invokers) {
        if (invokers.isEmpty()) {
            return Optional.empty();
        }
        if (invokers.size() == 1) {
            return Optional.of(invokers.getFirst());
        }
        return Optional.of(new DelegatingHandlerInvoker(invokers.getFirst()){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                Object result = this.delegate.invoke();
                for (int i = 1; i < invokers.size(); ++i) {
                    result = combiner.apply(result, ((HandlerInvoker)invokers.get(i)).invoke());
                }
                return result;
            }
        });
    }

    default public HandlerInvoker andFinally(final HandlerInvoker other) {
        return new DelegatingHandlerInvoker(this, this){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                try {
                    Object object = this.delegate.invoke();
                    return object;
                }
                finally {
                    other.invoke();
                }
            }
        };
    }

    public Class<?> getTargetClass();

    public Executable getMethod();

    public <A extends Annotation> A getMethodAnnotation();

    public boolean expectResult();

    public boolean isPassive();

    default public Object invoke() {
        return this.invoke((firstResult, secondResult) -> firstResult);
    }

    public Object invoke(BiFunction<Object, Object, Object> var1);

    public static final class SimpleInvoker
    implements HandlerInvoker {
        private static final SimpleInvoker noOpInvoker = new SimpleInvoker(() -> null);
        private static final Executable method = ObjectUtils.call(() -> SimpleInvoker.class.getMethod("invoke", new Class[0]));
        private final Callable<?> callable;

        @Override
        public Class<?> getTargetClass() {
            return SimpleInvoker.class;
        }

        @Override
        public Executable getMethod() {
            return method;
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return null;
        }

        @Override
        public boolean expectResult() {
            return false;
        }

        @Override
        public boolean isPassive() {
            return false;
        }

        @Override
        public Object invoke(BiFunction<Object, Object, Object> combiner) {
            return this.callable.call();
        }

        @ConstructorProperties(value={"callable"})
        @Generated
        private SimpleInvoker(Callable<?> callable) {
            this.callable = callable;
        }
    }

    public static abstract class DelegatingHandlerInvoker
    implements HandlerInvoker {
        protected final HandlerInvoker delegate;

        @Override
        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }

        @Override
        public Executable getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return this.delegate.getMethodAnnotation();
        }

        @Override
        public boolean expectResult() {
            return this.delegate.expectResult();
        }

        @Override
        public boolean isPassive() {
            return this.delegate.isPassive();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        public DelegatingHandlerInvoker(HandlerInvoker delegate) {
            this.delegate = delegate;
        }
    }
}

