/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.tracking;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.api.SerializedMessage;
import io.fluxzero.common.api.tracking.Position;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class MessageBatch {
    private final int[] segment;
    private final List<SerializedMessage> messages;
    private final Long lastIndex;
    private final Position position;
    private final boolean caughtUp;

    @JsonIgnore
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.messages.size();
    }

    @JsonIgnore
    public long getBytes() {
        return this.messages.stream().mapToLong(SerializedMessage::getBytes).sum();
    }

    public String toString() {
        return "MessageBatch{segment=" + Arrays.toString(this.segment) + ", lastIndex=" + this.lastIndex + ", message count=" + this.messages.size() + "}";
    }

    @JsonIgnore
    public Metric toMetric() {
        return new Metric(this.segment, this.getSize(), this.getBytes(), this.lastIndex, this.position, this.caughtUp);
    }

    @ConstructorProperties(value={"segment", "messages", "lastIndex", "position", "caughtUp"})
    @Generated
    public MessageBatch(int[] segment, List<SerializedMessage> messages, Long lastIndex, Position position, boolean caughtUp) {
        this.segment = segment;
        this.messages = messages;
        this.lastIndex = lastIndex;
        this.position = position;
        this.caughtUp = caughtUp;
    }

    @Generated
    public int[] getSegment() {
        return this.segment;
    }

    @Generated
    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    @Generated
    public Long getLastIndex() {
        return this.lastIndex;
    }

    @Generated
    public Position getPosition() {
        return this.position;
    }

    @Generated
    public boolean isCaughtUp() {
        return this.caughtUp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageBatch)) {
            return false;
        }
        MessageBatch other = (MessageBatch)o;
        if (this.isCaughtUp() != other.isCaughtUp()) {
            return false;
        }
        Long this$lastIndex = this.getLastIndex();
        Long other$lastIndex = other.getLastIndex();
        if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
            return false;
        }
        if (!Arrays.equals(this.getSegment(), other.getSegment())) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCaughtUp() ? 79 : 97);
        Long $lastIndex = this.getLastIndex();
        result = result * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSegment());
        List<SerializedMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    @Generated
    public MessageBatch withMessages(List<SerializedMessage> messages) {
        return this.messages == messages ? this : new MessageBatch(this.segment, messages, this.lastIndex, this.position, this.caughtUp);
    }

    public static final class Metric {
        private final int[] segment;
        private final int size;
        private final long bytes;
        private final Long lastIndex;
        private final Position position;
        private final boolean caughtUp;

        @ConstructorProperties(value={"segment", "size", "bytes", "lastIndex", "position", "caughtUp"})
        @Generated
        public Metric(int[] segment, int size, long bytes, Long lastIndex, Position position, boolean caughtUp) {
            this.segment = segment;
            this.size = size;
            this.bytes = bytes;
            this.lastIndex = lastIndex;
            this.position = position;
            this.caughtUp = caughtUp;
        }

        @Generated
        public int[] getSegment() {
            return this.segment;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public Long getLastIndex() {
            return this.lastIndex;
        }

        @Generated
        public Position getPosition() {
            return this.position;
        }

        @Generated
        public boolean isCaughtUp() {
            return this.caughtUp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            if (this.isCaughtUp() != other.isCaughtUp()) {
                return false;
            }
            Long this$lastIndex = this.getLastIndex();
            Long other$lastIndex = other.getLastIndex();
            if (this$lastIndex == null ? other$lastIndex != null : !((Object)this$lastIndex).equals(other$lastIndex)) {
                return false;
            }
            if (!Arrays.equals(this.getSegment(), other.getSegment())) {
                return false;
            }
            Position this$position = this.getPosition();
            Position other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            result = result * 59 + (this.isCaughtUp() ? 79 : 97);
            Long $lastIndex = this.getLastIndex();
            result = result * 59 + ($lastIndex == null ? 43 : ((Object)$lastIndex).hashCode());
            result = result * 59 + Arrays.hashCode(this.getSegment());
            Position $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageBatch.Metric(segment=" + Arrays.toString(this.getSegment()) + ", size=" + this.getSize() + ", bytes=" + this.getBytes() + ", lastIndex=" + this.getLastIndex() + ", position=" + String.valueOf(this.getPosition()) + ", caughtUp=" + this.isCaughtUp() + ")";
        }
    }
}

