/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxzero.common.serialization.NullCollectionsAsEmptyModule;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class Metadata {
    public static JsonMapper objectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule((Module)new NullCollectionsAsEmptyModule())).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    private final Map<String, String> entries;

    @JsonAnyGetter
    public Map<String, String> getEntries() {
        return this.entries;
    }

    public static Metadata of(Object ... keyValues) {
        return Metadata.empty().with(keyValues);
    }

    public static Metadata empty() {
        return new Metadata(Collections.emptyMap());
    }

    public static Metadata of(Object key, Object value) {
        return Metadata.empty().with(key, value);
    }

    public static Metadata of(Map<?, ?> map) {
        return Metadata.empty().with(map);
    }

    @JsonCreator
    private Metadata(Map<String, String> entries) {
        this.entries = entries;
    }

    public String toString() {
        return this.entries.toString();
    }

    public Metadata with(Map<?, ?> values) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        values.forEach((key, value) -> Metadata.with(key, value, map));
        return new Metadata(map);
    }

    public Metadata with(Metadata metadata) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        map.putAll(metadata.entries);
        return new Metadata(map);
    }

    public Metadata with(Object ... keyValues) {
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("Failed to create metadata for keys " + Arrays.toString(keyValues));
        }
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        for (int i = 0; i < keyValues.length; i += 2) {
            Metadata.with(keyValues[i].toString(), keyValues[i + 1], map);
        }
        return new Metadata(map);
    }

    public Metadata with(Object key, Object value) {
        return new Metadata(Metadata.with(key, value, new HashMap<String, String>(this.entries)));
    }

    public Metadata addIfAbsent(Object key, Object value) {
        return this.containsKey(key) ? this : this.with(key, value);
    }

    public Metadata addIfAbsent(Map<?, ?> map) {
        map = new HashMap(map);
        map.keySet().removeIf(this::containsKey);
        return this.with(map);
    }

    private static Map<String, String> with(@NonNull Object key, Object value, Map<String, String> entries) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String keyString = key.toString();
        if (value == null) {
            entries.remove(keyString);
            return entries;
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            if (optional.isEmpty()) {
                return entries;
            }
            value = optional.get();
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            value = e.name();
        }
        entries.put(keyString, value instanceof String ? (String)value : objectMapper.writeValueAsString(value));
        return entries;
    }

    private static Map<String, String> withTrace(Object key, Object value, Map<String, String> entries) {
        return Metadata.with("$trace." + String.valueOf(key), value, entries);
    }

    public Metadata withTrace(Object key, Object value) {
        return new Metadata(Metadata.withTrace(key, value, new HashMap<String, String>(this.entries)));
    }

    public Metadata without(Object key) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        map.remove(key.toString());
        return new Metadata(map);
    }

    public Metadata withoutIf(Predicate<String> check) {
        HashMap<String, String> map = new HashMap<String, String>(this.entries);
        Iterator iterator = map.keySet().iterator();
        iterator.forEachRemaining(key -> {
            if (check.test((String)key)) {
                iterator.remove();
            }
        });
        return new Metadata(map);
    }

    public String get(Object key) {
        return this.entries.get(key.toString());
    }

    public Optional<String> getOptionally(Object key) {
        return Optional.ofNullable(this.get(key));
    }

    public <T> T get(Object key, Class<T> type) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)value;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        try {
            return (T)objectMapper.readValue(value, type);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to deserialize value %s to a %s for key %s", value, type.getSimpleName(), key), e);
        }
    }

    public <T> Optional<T> getOptionally(Object key, Class<T> type) {
        return Optional.ofNullable(this.get(key, type));
    }

    public <T> T get(Object key, TypeReference<T> type) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(value, type);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to deserialize value %s to a %s for key %s", value, type, key), e);
        }
    }

    public <T> Optional<T> getOptionally(Object key, TypeReference<T> type) {
        return Optional.ofNullable(this.get(key, type));
    }

    public <X extends Throwable> String getOrThrow(Object key, Supplier<? extends X> errorSupplier) throws X {
        return Optional.ofNullable(this.get(key)).orElseThrow(errorSupplier);
    }

    @JsonIgnore
    public Map<String, String> getTraceEntries() {
        return this.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$trace.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean containsKey(Object key) {
        return this.entries.containsKey(key.toString());
    }

    public boolean containsAnyKey(Object ... keys) {
        return Arrays.stream(keys).anyMatch(this::containsKey);
    }

    public boolean contains(@NonNull Object key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String result = value instanceof String ? this.get(key) : this.get(key, value.getClass());
        return Objects.equals(result, value);
    }

    public boolean contains(@NonNull Metadata metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.entries.entrySet().containsAll(metadata.entries.entrySet());
    }

    public String getOrDefault(Object key, String defaultValue) {
        return this.entries.getOrDefault(key.toString(), defaultValue);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.entries.entrySet();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        Map<String, String> this$entries = this.getEntries();
        Map<String, String> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }
}

