/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

public class LazyInputStream
extends InputStream {
    private final Supplier<? extends InputStream> supplier;
    private volatile InputStream delegate;

    public LazyInputStream(Supplier<? extends InputStream> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream delegate() throws IOException {
        if (this.delegate == null) {
            LazyInputStream lazyInputStream = this;
            synchronized (lazyInputStream) {
                if (this.delegate == null) {
                    this.delegate = this.supplier.get();
                }
            }
        }
        return this.delegate;
    }

    @Override
    public int read() throws IOException {
        return this.delegate().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate().available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.delegate().mark(readlimit);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate().reset();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.delegate().markSupported();
        }
        catch (IOException e) {
            return false;
        }
    }
}

