/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.MemoizingFunction;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public interface MemoizingBiFunction<T, U, R>
extends BiFunction<T, U, R> {
    public boolean isCached(T var1, U var2);

    public R remove(T var1, U var2);

    public void clear();

    public void forEach(Consumer<? super R> var1);

    @NonNull
    default public <K1> MemoizingFunction<K1, R> compose(final @NonNull Function<? super K1, Map.Entry<? extends T, ? extends U>> before) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        final MemoizingBiFunction origin = this;
        return new MemoizingFunction<K1, R>(this){

            @Override
            public R apply(K1 key) {
                Map.Entry pair = (Map.Entry)before.apply(key);
                return origin.apply(pair.getKey(), pair.getValue());
            }

            @Override
            public R remove(K1 key) {
                Map.Entry pair = (Map.Entry)before.apply(key);
                return origin.remove(pair.getKey(), pair.getValue());
            }

            @Override
            public boolean isCached(K1 key) {
                Map.Entry pair = (Map.Entry)before.apply(key);
                return origin.isCached(pair.getKey(), pair.getValue());
            }

            @Override
            public void forEach(Consumer<? super R> consumer) {
                origin.forEach(consumer);
            }

            @Override
            public void clear() {
                origin.clear();
            }
        };
    }
}

