/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class DirectExecutorService
extends AbstractExecutorService {
    private final AtomicBoolean shutDown = new AtomicBoolean();
    private final CopyOnWriteArrayList<Runnable> runningTasks = new CopyOnWriteArrayList();

    public static ExecutorService newInstance() {
        return new DirectExecutorService();
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Executor was shut down");
        }
        try {
            this.runningTasks.add(command);
            command.run();
        }
        finally {
            this.runningTasks.remove(command);
        }
    }

    @Override
    public void shutdown() {
        this.shutDown.set(true);
    }

    @Override
    public boolean isShutdown() {
        return this.shutDown.get();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.runningTasks;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.runningTasks.isEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (!this.isTerminated()) {
            long remaining = deadline - System.nanoTime();
            if (remaining <= 0L) {
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(remaining), 10L));
        }
        return true;
    }

    @Generated
    private DirectExecutorService() {
    }
}

