/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.serialization;

import com.google.auto.service.AutoService;
import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.serialization.RegisterType;
import io.fluxzero.common.serialization.TypeRegistry;
import java.beans.ConstructorProperties;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;

@SupportedAnnotationTypes(value={"io.fluxzero.common.serialization.RegisterType"})
@AutoService(value={Processor.class})
public class TypeRegistryProcessor
extends AbstractProcessor {
    static final String ANNOTATION = "io.fluxzero.common.serialization.RegisterType";
    public static final String TYPES_FILE = "META-INF/" + TypeRegistry.class.getName();
    private static final String PREFIXES_FILE = "META-INF/type-registry-prefixes";
    private final Set<Prefix> roundPrefixes = new LinkedHashSet<Prefix>();
    private final AtomicReference<Object> typesResource = new AtomicReference();
    private final AtomicReference<Object> prefixesResource = new AtomicReference();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (!this.isNewProcess()) {
            this.storeTypes();
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.roundPrefixes.addAll(roundEnv.getRootElements().stream().flatMap(this::getPrefixes).toList());
        if (roundEnv.processingOver() && this.isNewProcess()) {
            this.storeTypes();
        }
        return true;
    }

    boolean isNewProcess() {
        return this.getTypesResource().getLastModified() == 0L;
    }

    void storeTypes() {
        Set<Prefix> prefixes = this.updateAndGetPrefixes();
        TreeSet types = Stream.concat(this.getStoredTypes(prefixes), this.getNewTypes(prefixes)).collect(Collectors.toCollection(TreeSet::new));
        try (Writer resourceWriter = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", TYPES_FILE, new Element[0]).openWriter();){
            for (String type : types) {
                resourceWriter.write(type + "\n");
            }
        }
    }

    Stream<String> getStoredTypes(Set<Prefix> prefixes) {
        if (this.isNewProcess()) {
            return Stream.empty();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.getTypesResource().openInputStream());){
            while (scanner.hasNextLine()) {
                String type = scanner.nextLine();
                if (!this.isType(type) || !prefixes.stream().anyMatch(p -> p.matches(type))) continue;
                result.add(type);
            }
        }
        return result.stream();
    }

    Stream<String> getNewTypes(Set<Prefix> prefixes) {
        return this.processingEnv.getElementUtils().getAllModuleElements().stream().flatMap(this::getClasses).filter(t -> prefixes.stream().anyMatch(prefix -> prefix.matches(t.getQualifiedName().toString()))).map(c -> this.processingEnv.getElementUtils().getBinaryName((TypeElement)c).toString());
    }

    Set<Prefix> updateAndGetPrefixes() {
        LinkedHashSet<Prefix> prefixes = new LinkedHashSet<Prefix>(this.roundPrefixes);
        FileObject resource = this.getPrefixesResource();
        if (resource.getLastModified() != 0L) {
            try (Scanner scanner = new Scanner(resource.openInputStream());){
                while (scanner.hasNextLine()) {
                    Prefix prefix = new Prefix(scanner.nextLine());
                    String root = prefix.getRoot();
                    if (!this.isPackage(root) && !this.isType(root)) continue;
                    prefixes.add(prefix);
                }
            }
        }
        resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PREFIXES_FILE, new Element[0]);
        try (Writer resourceWriter = resource.openWriter();){
            for (Prefix prefix : prefixes) {
                String root = prefix.getRoot();
                if (!this.isPackage(root) && !this.isType(root)) continue;
                resourceWriter.write(String.valueOf(prefix) + "\n");
            }
        }
        return prefixes;
    }

    Stream<Prefix> getPrefixes(Element element) {
        try {
            RegisterType registerType = element.getAnnotation(RegisterType.class);
            if (registerType != null) {
                String root = ((QualifiedNameable)element).getQualifiedName().toString();
                return Stream.of(new Prefix(root, Arrays.asList(registerType.contains())));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element.getEnclosedElements().stream().flatMap(this::getPrefixes);
    }

    Stream<TypeElement> getClasses(Element element) {
        try {
            Stream<Object> stream;
            if (element instanceof TypeElement) {
                TypeElement t = (TypeElement)element;
                stream = Stream.of(t);
            } else {
                stream = Stream.empty();
            }
            return Stream.concat(stream, element.getEnclosedElements().stream().flatMap(this::getClasses));
        }
        catch (Throwable e) {
            this.processingEnv.getMessager().printWarning("Failed to get classes of element: " + String.valueOf(element) + ". " + e.getMessage());
            return Stream.empty();
        }
    }

    boolean isType(String fqn) {
        return this.processingEnv.getElementUtils().getTypeElement(fqn.replace("$", ".")) != null;
    }

    boolean isPackage(String fqn) {
        return this.processingEnv.getElementUtils().getPackageElement(fqn) != null;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public FileObject getTypesResource() {
        Object $value = this.typesResource.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.typesResource;
            synchronized (atomicReference) {
                $value = this.typesResource.get();
                if ($value == null) {
                    FileObject actualValue = ObjectUtils.call(() -> this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", TYPES_FILE));
                    $value = actualValue == null ? this.typesResource : actualValue;
                    this.typesResource.set($value);
                }
            }
        }
        return (FileObject)($value == this.typesResource ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public FileObject getPrefixesResource() {
        Object $value = this.prefixesResource.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.prefixesResource;
            synchronized (atomicReference) {
                $value = this.prefixesResource.get();
                if ($value == null) {
                    FileObject actualValue = ObjectUtils.call(() -> this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", PREFIXES_FILE));
                    $value = actualValue == null ? this.prefixesResource : actualValue;
                    this.prefixesResource.set($value);
                }
            }
        }
        return (FileObject)($value == this.prefixesResource ? null : $value);
    }

    static final class Prefix {
        private final String root;
        private final List<String> filters;
        private final AtomicReference<Object> filterMatch = new AtomicReference();

        public Prefix(String storedPrefix) {
            String[] parts = storedPrefix.split(",");
            this.root = parts[0];
            this.filters = Arrays.stream(parts).skip(1L).toList();
        }

        public boolean matches(String type) {
            return (type = type.replace("$", ".")).startsWith(this.root) && this.getFilterMatch().test(type);
        }

        public String toString() {
            return Stream.concat(Stream.of(this.root), this.filters.stream()).collect(Collectors.joining(","));
        }

        @Generated
        public String getRoot() {
            return this.root;
        }

        @Generated
        public List<String> getFilters() {
            return this.filters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prefix)) {
                return false;
            }
            Prefix other = (Prefix)o;
            String this$root = this.getRoot();
            String other$root = other.getRoot();
            if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
                return false;
            }
            List<String> this$filters = this.getFilters();
            List<String> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            Predicate<String> this$filterMatch = this.getFilterMatch();
            Predicate<String> other$filterMatch = other.getFilterMatch();
            return !(this$filterMatch == null ? other$filterMatch != null : !this$filterMatch.equals(other$filterMatch));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : $root.hashCode());
            List<String> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            Predicate<String> $filterMatch = this.getFilterMatch();
            result = result * 59 + ($filterMatch == null ? 43 : $filterMatch.hashCode());
            return result;
        }

        @ConstructorProperties(value={"root", "filters"})
        @Generated
        public Prefix(String root, List<String> filters) {
            this.root = root;
            this.filters = filters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public Predicate<String> getFilterMatch() {
            Object $value = this.filterMatch.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.filterMatch;
                synchronized (atomicReference) {
                    $value = this.filterMatch.get();
                    if ($value == null) {
                        Predicate<String> actualValue = this.getFilters().stream().map(Pattern::compile).map(Pattern::asPredicate).reduce(Predicate::or).orElse(s -> true);
                        $value = actualValue == null ? this.filterMatch : actualValue;
                        this.filterMatch.set($value);
                    }
                }
            }
            return (Predicate)($value == this.filterMatch ? null : $value);
        }
    }
}

