/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.constraints;

import io.fluxzero.common.api.search.Constraint;
import io.fluxzero.common.api.search.NoOpConstraint;
import io.fluxzero.common.api.search.constraints.AllConstraint;
import io.fluxzero.common.api.search.constraints.ContainsConstraint;
import io.fluxzero.common.api.search.constraints.NotConstraint;
import io.fluxzero.common.api.search.constraints.PathConstraint;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class QueryConstraint
extends PathConstraint {
    private static final String operator = "&|()!";
    private static final Pattern termPattern = Pattern.compile(String.format("\"[^\"]*\"|[%1$s]|[*%2$s][^\\s%1$s]+[*%2$s]|[*%2$s]+", "&|()!", "\\p{L}0-9"), 8);
    private static final Pattern splitOnInnerAsterisk = Pattern.compile(String.format("(?<=[%1$s])\\*(?=[%1$s])", "\\p{L}0-9"));
    @NonNull
    private final String query;
    private final boolean lookAheadForAllTerms;
    private final List<String> paths;
    private final AtomicReference<Object> decompose = new AtomicReference();

    public static Constraint query(String query, String ... paths) {
        return QueryConstraint.query(query, false, paths);
    }

    public static Constraint query(String query, boolean lookAheadForAllTerms, String ... paths) {
        return StringUtils.isBlank((CharSequence)query) ? NoOpConstraint.instance : new QueryConstraint(query, lookAheadForAllTerms, List.of(paths));
    }

    @Override
    public boolean matches(Document document) {
        return this.decompose().matches(document);
    }

    @Override
    protected boolean matches(Document.Entry entry, Document document) {
        throw new UnsupportedOperationException();
    }

    private List<Constraint> createConstraints(List<String> parts) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        ListIterator<String> iterator = parts.listIterator();
        while (iterator.hasNext()) {
            this.parsePart(iterator.next(), iterator, result);
        }
        return result;
    }

    private void parsePart(String part, ListIterator<String> iterator, List<Constraint> constraints) {
        switch (part) {
            case "(": {
                this.handleGroupStart(iterator, constraints);
                break;
            }
            case "|": {
                this.handleOr(iterator, constraints);
                break;
            }
            case "!": {
                this.handleNot(iterator, constraints);
                break;
            }
            case "": {
                break;
            }
            default: {
                this.handleTerm(part, constraints);
            }
        }
    }

    private void handleGroupStart(ListIterator<String> iterator, List<Constraint> constraints) {
        String part;
        ArrayList<Constraint> subList = new ArrayList<Constraint>();
        while (iterator.hasNext() && !(part = iterator.next()).equals(")")) {
            this.parsePart(part, iterator, subList);
        }
        constraints.add(AllConstraint.all(subList));
    }

    private void handleOr(ListIterator<String> iterator, List<Constraint> constraints) {
        if (iterator.hasNext() && !constraints.isEmpty()) {
            Constraint leftHandConstraint = constraints.remove(constraints.size() - 1);
            ArrayList<Constraint> rightHandPart = new ArrayList<Constraint>();
            this.parsePart(iterator.next(), iterator, rightHandPart);
            constraints.add(leftHandConstraint.or(AllConstraint.all(rightHandPart)));
        } else {
            this.parsePart("OR", iterator, constraints);
        }
    }

    private void handleNot(ListIterator<String> iterator, List<Constraint> constraints) {
        ArrayList<Constraint> subList = new ArrayList<Constraint>();
        if (iterator.hasNext()) {
            this.parsePart(iterator.next(), iterator, subList);
        }
        constraints.add(NotConstraint.not(AllConstraint.all(subList)));
    }

    private void handleTerm(String term, List<Constraint> constraints) {
        if (term.startsWith("\"") && term.endsWith("\"")) {
            constraints.add(ContainsConstraint.contains(term.substring(1, term.length() - 1), false, false, (String[])this.paths.toArray(String[]::new)));
            return;
        }
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        String[] parts = splitOnInnerAsterisk.split(term);
        for (int i = 0; i < parts.length; ++i) {
            boolean prefixSearch = i != 0;
            boolean postfixSearch = i != parts.length - 1 || this.lookAheadForAllTerms;
            String part = parts[i];
            if (part.endsWith("*")) {
                part = part.substring(0, part.length() - 1);
                postfixSearch = true;
            }
            if (part.startsWith("*")) {
                part = part.substring(1);
                prefixSearch = true;
            }
            result.add(ContainsConstraint.contains(part, prefixSearch, postfixSearch, (String[])this.paths.toArray(String[]::new)));
        }
        constraints.add(AllConstraint.all(result));
    }

    private List<String> splitInTermsAndOperators(String query) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = termPattern.matcher(query.trim());
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.isEmpty() || group.equals("\"") || group.equals("AND") || group.equals("&")) continue;
            parts.add(group.equals("OR") ? "|" : group);
        }
        return parts;
    }

    @NonNull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public boolean isLookAheadForAllTerms() {
        return this.lookAheadForAllTerms;
    }

    @Override
    @Generated
    public List<String> getPaths() {
        return this.paths;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryConstraint)) {
            return false;
        }
        QueryConstraint other = (QueryConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLookAheadForAllTerms() != other.isLookAheadForAllTerms()) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryConstraint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLookAheadForAllTerms() ? 79 : 97);
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueryConstraint(query=" + this.getQuery() + ", lookAheadForAllTerms=" + this.isLookAheadForAllTerms() + ", paths=" + String.valueOf(this.getPaths()) + ")";
    }

    @ConstructorProperties(value={"query", "lookAheadForAllTerms", "paths"})
    @Generated
    private QueryConstraint(@NonNull String query, boolean lookAheadForAllTerms, List<String> paths) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
        this.lookAheadForAllTerms = lookAheadForAllTerms;
        this.paths = paths;
    }

    @Generated
    public QueryConstraint withLookAheadForAllTerms(boolean lookAheadForAllTerms) {
        return this.lookAheadForAllTerms == lookAheadForAllTerms ? this : new QueryConstraint(this.query, lookAheadForAllTerms, this.paths);
    }

    @Override
    @Generated
    public QueryConstraint withPaths(List<String> paths) {
        return this.paths == paths ? this : new QueryConstraint(this.query, this.lookAheadForAllTerms, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public Constraint decompose() {
        Object $value = this.decompose.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.decompose;
            synchronized (atomicReference) {
                $value = this.decompose.get();
                if ($value == null) {
                    Constraint actualValue = AllConstraint.all(this.createConstraints(this.splitInTermsAndOperators(this.getQuery())));
                    $value = actualValue == null ? this.decompose : actualValue;
                    this.decompose.set($value);
                }
            }
        }
        return (Constraint)($value == this.decompose ? null : $value);
    }
}

