/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.ThrowingRunnable;
import io.fluxzero.common.api.Data;
import io.fluxzero.common.api.Metadata;
import io.fluxzero.common.api.SerializedMessage;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    private static final Random random = new Random();

    public static SerializedMessage createMessage() {
        return TestUtils.createMessages(1).get(0);
    }

    public static List<SerializedMessage> createMessages(int count) {
        return IntStream.range(0, count).mapToObj(i -> {
            ByteBuffer byteBuffer = ByteBuffer.allocate(20).putInt(i);
            byte[] randomBytes = new byte[16];
            random.nextBytes(randomBytes);
            return byteBuffer.put(randomBytes).array();
        }).map(bytes -> new SerializedMessage(new Data(bytes, "test", 0, null), Metadata.empty(), "someId", Long.valueOf(Clock.systemUTC().millis()))).collect(Collectors.toList());
    }

    public static void assertEqualMessages(List<SerializedMessage> expected, List<SerializedMessage> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Lists have a different size");
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertArrayEquals((byte[])((byte[])expected.get(i).getData().getValue()), (byte[])((byte[])actual.get(i).getData().getValue()));
        }
    }

    public static void sleepAWhile(int millis) {
        Thread.sleep(millis);
    }

    public static int getAvailablePort() {
        int n;
        try (ServerSocket socket = new ServerSocket(0);){
            n = socket.getLocalPort();
        }
        return n;
    }

    public static void runWithSystemProperties(ThrowingRunnable runnable, String ... propertyKeysAndValues) {
        TestUtils.callWithSystemProperties(() -> {
            runnable.run();
            return null;
        }, propertyKeysAndValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V callWithSystemProperties(Callable<V> callable, String ... propertyKeysAndValues) {
        if (propertyKeysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected pairs of keys and values");
        }
        try {
            for (int i = 0; i < propertyKeysAndValues.length; i += 2) {
                System.setProperty(propertyKeysAndValues[i], propertyKeysAndValues[i + 1]);
            }
            V i = callable.call();
            return i;
        }
        finally {
            int i2 = 0;
            while (true) {
                if (i2 >= propertyKeysAndValues.length) {
                }
                System.clearProperty(propertyKeysAndValues[i2]);
                i2 += 2;
            }
        }
    }
}

