/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search;

import io.fluxzero.common.api.RequestResult;
import io.fluxzero.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public final class SearchDocumentsResult
implements RequestResult {
    private final long requestId;
    private final List<SerializedDocument> matches;
    private final long timestamp = System.currentTimeMillis();

    @Override
    public Metric toMetric() {
        return new Metric(this.matches.size(), this.matches.stream().mapToLong(SerializedDocument::bytes).sum(), this.timestamp);
    }

    public int size() {
        return this.matches.size();
    }

    public SerializedDocument lastMatch() {
        return this.matches.isEmpty() ? null : this.matches.getLast();
    }

    @ConstructorProperties(value={"requestId", "matches"})
    @Generated
    public SearchDocumentsResult(long requestId, List<SerializedDocument> matches) {
        this.requestId = requestId;
        this.matches = matches;
    }

    @Override
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @Generated
    public List<SerializedDocument> getMatches() {
        return this.matches;
    }

    @Override
    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDocumentsResult)) {
            return false;
        }
        SearchDocumentsResult other = (SearchDocumentsResult)o;
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<SerializedDocument> this$matches = this.getMatches();
        List<SerializedDocument> other$matches = other.getMatches();
        return !(this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<SerializedDocument> $matches = this.getMatches();
        result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchDocumentsResult(requestId=" + this.getRequestId() + ", matches=" + String.valueOf(this.getMatches()) + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static final class Metric {
        private final int size;
        private final long bytes;
        private final long timestamp;

        @ConstructorProperties(value={"size", "bytes", "timestamp"})
        @Generated
        public Metric(int size, long bytes, long timestamp) {
            this.size = size;
            this.bytes = bytes;
            this.timestamp = timestamp;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        @Generated
        public String toString() {
            return "SearchDocumentsResult.Metric(size=" + this.getSize() + ", bytes=" + this.getBytes() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

