/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.reflection.ReflectionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.SequencedCollection;
import java.util.function.BiConsumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void writeFile(String fileName, String content) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write(content);
        }
    }

    public static String loadFile(String fileName) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(Class<?> referencePoint, String fileName) {
        return FileUtils.loadFile(referencePoint, fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(String fileName, Charset charset) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, charset);
    }

    public static String loadFile(Class<?> referencePoint, String fileName, Charset charset) {
        try {
            return FileUtils.loadFile(referencePoint.getResource(fileName).toURI(), charset);
        }
        catch (NullPointerException e) {
            log.error("Resource {} not found in package {}", (Object)fileName, (Object)referencePoint.getPackageName());
            throw e;
        }
    }

    public static URI getFile(Class<?> referencePoint, String fileName) {
        return referencePoint.getResource(fileName).toURI();
    }

    public static String loadFile(URI uri) {
        return FileUtils.loadFile(uri, StandardCharsets.UTF_8);
    }

    public static String loadFile(URI uri, Charset charset) {
        return FileUtils.loadFile(uri.toURL(), charset);
    }

    public static String loadFile(File file) {
        return FileUtils.loadFile(file, StandardCharsets.UTF_8);
    }

    public static String loadFile(File file, Charset charset) {
        return FileUtils.loadFile(file.toURI().toURL(), charset);
    }

    public static String loadFile(URL url, Charset charset) {
        String string;
        block12: {
            if (url.getFile() == null || url.getFile().isEmpty()) {
                log.error("Not a file url: {}", (Object)url);
                throw new IllegalArgumentException("Not a file url: " + String.valueOf(url));
            }
            InputStream inputStream = url.openStream();
            try {
                string = new Scanner(inputStream, charset).useDelimiter("\\A").next();
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("File not found {}", (Object)url, (Object)e);
                    throw e;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static Optional<String> tryLoadFile(String fileName) {
        return FileUtils.tryLoadFile(ReflectionUtils.getCallerClass(), fileName, StandardCharsets.UTF_8);
    }

    public static Optional<String> tryLoadFile(Class<?> referencePoint, String fileName) {
        return FileUtils.tryLoadFile(referencePoint, fileName, StandardCharsets.UTF_8);
    }

    public static Optional<String> tryLoadFile(String fileName, Charset charset) {
        return FileUtils.tryLoadFile(ReflectionUtils.getCallerClass(), fileName, charset);
    }

    public static Optional<String> tryLoadFile(Class<?> referencePoint, String fileName, Charset charset) {
        try {
            return FileUtils.tryLoadFile(new File(referencePoint.getResource(fileName).toURI()), charset);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static Optional<String> tryLoadFile(File file) {
        return FileUtils.tryLoadFile(file, StandardCharsets.UTF_8);
    }

    public static Optional<String> tryLoadFile(File file, Charset charset) {
        Optional<String> optional;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            optional = Optional.ofNullable(new Scanner((InputStream)inputStream, charset).useDelimiter("\\A").next());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        }
        ((InputStream)inputStream).close();
        return optional;
    }

    public static URI safeResolve(URI base, String relativePath) {
        if ("jar".equals(base.getScheme())) {
            return URI.create("jar:" + String.valueOf(URI.create(base.getSchemeSpecificPart()).resolve(relativePath)));
        }
        return base.resolve(relativePath);
    }

    public static URI getResourceBaseUri(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        return FileUtils.getResourceBaseUri(resourcePath, ReflectionUtils.getCallerClass().getClassLoader());
    }

    public static URI getResourceBaseUri(@NonNull String resourcePath, ClassLoader classLoader) {
        URL resourceUrl;
        Object normalized;
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        Object object = normalized = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        if (!((String)normalized).endsWith("/")) {
            normalized = (String)normalized + "/";
        }
        if ((resourceUrl = classLoader.getResource((String)normalized)) == null) {
            throw new IllegalArgumentException("Resource path not found: " + resourcePath);
        }
        try {
            return resourceUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI for resource: " + resourcePath, e);
        }
    }

    public static Properties loadProperties(String fileName) {
        fileName = fileName.startsWith("/") ? fileName.substring(1) : fileName;
        Properties result = new Properties();
        SequencedCollection resources = Collections.list(ReflectionUtils.getCallerClass().getClassLoader().getResources(fileName)).reversed();
        for (URL resource : resources) {
            InputStream inputStream = resource.openStream();
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    Object existing = result.put(k, v);
                    if (existing != null && !Objects.equals(existing, v)) {
                        log.warn("Property {} has been registered in more than one module. This may give unpredictable results.", k);
                    }
                }));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return result;
    }
}

