/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.reflection;

import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class GenericTypeResolver {
    public static Type getGenericType(Class<?> clazz, Class<?> target) {
        return GenericTypeResolver.resolveType(clazz, target, new HashMap());
    }

    private static Type resolveType(Class<?> clazz, Class<?> target, Map<TypeVariable<?>, Type> typeVarMap) {
        if (clazz == null || clazz == Object.class) {
            return null;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        Type resolved = GenericTypeResolver.matchAndResolve(genericSuperclass, target, typeVarMap);
        if (resolved != null) {
            return resolved;
        }
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            resolved = GenericTypeResolver.matchAndResolve(genericInterface, target, typeVarMap);
            if (resolved == null) continue;
            return resolved;
        }
        return GenericTypeResolver.resolveType(clazz.getSuperclass(), target, typeVarMap);
    }

    private static Type matchAndResolve(Type candidate, Class<?> target, Map<TypeVariable<?>, Type> typeVarMap) {
        if (candidate instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)candidate;
            Class rawType = (Class)pt.getRawType();
            if (rawType.equals(target)) {
                return GenericTypeResolver.reifyType(pt, typeVarMap);
            }
            HashMap newMap = new HashMap(typeVarMap);
            TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
            Type[] args = pt.getActualTypeArguments();
            for (int i = 0; i < vars.length; ++i) {
                newMap.put(vars[i], GenericTypeResolver.resolveTypeVariable(args[i], typeVarMap));
            }
            return GenericTypeResolver.resolveType(rawType, target, newMap);
        }
        if (candidate instanceof Class) {
            Class raw = (Class)candidate;
            if (raw.equals(target)) {
                return raw;
            }
            return GenericTypeResolver.resolveType(raw, target, typeVarMap);
        }
        return null;
    }

    private static Type reifyType(Type type, Map<TypeVariable<?>, Type> typeVarMap) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            Type[] args = (Type[])Arrays.stream(pt.getActualTypeArguments()).map(t -> GenericTypeResolver.resolveTypeVariable(t, typeVarMap)).toArray(Type[]::new);
            return new ParameterizedTypeImpl((Class)raw, args, pt.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            Type component = GenericTypeResolver.reifyType(((GenericArrayType)type).getGenericComponentType(), typeVarMap);
            return Array.newInstance((Class)GenericTypeResolver.erase(component), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return GenericTypeResolver.resolveTypeVariable(type, typeVarMap);
        }
        return type;
    }

    private static Type resolveTypeVariable(Type type, Map<TypeVariable<?>, Type> typeVarMap) {
        if (type instanceof TypeVariable) {
            Type resolved = typeVarMap.get(type);
            if (resolved != null) {
                return GenericTypeResolver.resolveTypeVariable(resolved, typeVarMap);
            }
            TypeVariable var = (TypeVariable)type;
            Type[] bounds = var.getBounds();
            return bounds.length > 0 ? GenericTypeResolver.resolveTypeVariable(bounds[0], typeVarMap) : Object.class;
        }
        if (type instanceof ParameterizedType) {
            return GenericTypeResolver.reifyType(type, typeVarMap);
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeResolver.reifyType(type, typeVarMap);
        }
        return type;
    }

    private static Type erase(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance((Class)GenericTypeResolver.erase(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        throw new IllegalArgumentException("Cannot erase type: " + String.valueOf(type));
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type[] actualTypeArguments;
        private final Type ownerType;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.rawType.getTypeName());
            if (this.actualTypeArguments.length > 0) {
                sb.append("<");
                for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.actualTypeArguments[i].getTypeName());
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @ConstructorProperties(value={"rawType", "actualTypeArguments", "ownerType"})
        @Generated
        public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
            this.ownerType = ownerType;
        }

        @Override
        @Generated
        public Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        @Generated
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        @Generated
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedTypeImpl)) {
                return false;
            }
            ParameterizedTypeImpl other = (ParameterizedTypeImpl)o;
            Type this$rawType = this.getRawType();
            Type other$rawType = other.getRawType();
            if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getActualTypeArguments(), other.getActualTypeArguments())) {
                return false;
            }
            Type this$ownerType = this.getOwnerType();
            Type other$ownerType = other.getOwnerType();
            return !(this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $rawType = this.getRawType();
            result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getActualTypeArguments());
            Type $ownerType = this.getOwnerType();
            result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
            return result;
        }
    }
}

