/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class SortableEntry
implements Comparable<SortableEntry> {
    private static final int DECIMALS = 6;
    private static final BigDecimal SCALE = BigDecimal.TEN.pow(6);
    private static final BigInteger MIN_ENCODED = BigInteger.ZERO;
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_ENCODED = MAX_LONG.subtract(MIN_LONG).multiply(SCALE.toBigInteger());
    private static final BigInteger OFFSET = MAX_LONG.multiply(SCALE.toBigInteger());
    private static final BigInteger SCALED_MIN = MIN_LONG.multiply(SCALE.toBigInteger());
    private static final int PAD_WIDTH = MAX_ENCODED.toString().length();
    public static final Comparator<SortableEntry> comparator = Comparator.comparing(SortableEntry::getName).thenComparing(SortableEntry::getValue, String::compareTo);
    private final String name;
    private final String value;
    @JsonIgnore
    private final AtomicReference<Object> path = new AtomicReference();

    public SortableEntry(String name, Object value) {
        this(name, SortableEntry.formatSortable(value));
    }

    public static String formatSortable(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Instant.class}, (Object)object, n)) {
            case -1 -> "";
            case 0 -> {
                Number n = (Number)object;
                yield SortableEntry.toSortableString(n);
            }
            case 1 -> {
                Instant instant = (Instant)object;
                yield SearchUtils.ISO_FULL.format(instant);
            }
            default -> SearchUtils.normalize(value.toString());
        };
    }

    @Override
    public int compareTo(@NotNull SortableEntry o) {
        return comparator.compare(this, o);
    }

    public static String toSortableString(Number number) {
        BigInteger scaled = SortableEntry.toBigDecimal(number).setScale(6, RoundingMode.HALF_UP).multiply(SCALE).toBigInteger().max(MIN_LONG).min(MAX_LONG).subtract(SCALED_MIN);
        return String.format("%0" + PAD_WIDTH + "d", scaled);
    }

    static BigDecimal toBigDecimal(Number number) {
        Number number2 = number;
        Objects.requireNonNull(number2);
        Number number3 = number2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Integer.class, Long.class, BigInteger.class}, (Object)number3, n)) {
            case 0 -> {
                BigDecimal bd;
                yield bd = (BigDecimal)number3;
            }
            case 1 -> {
                Integer i = (Integer)number3;
                yield new BigDecimal(i);
            }
            case 2 -> {
                Long i = (Long)number3;
                yield new BigDecimal(i);
            }
            case 3 -> {
                BigInteger bi = (BigInteger)number3;
                yield new BigDecimal(bi);
            }
            default -> BigDecimal.valueOf(number.doubleValue());
        };
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortableEntry)) {
            return false;
        }
        SortableEntry other = (SortableEntry)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Document.Path this$path = this.getPath();
        Document.Path other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Document.Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SortableEntry(name=" + this.getName() + ", value=" + this.getValue() + ", path=" + String.valueOf(this.getPath()) + ")";
    }

    @ConstructorProperties(value={"name", "value"})
    @Generated
    public SortableEntry(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Generated
    public SortableEntry withName(String name) {
        return this.name == name ? this : new SortableEntry(name, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Document.Path getPath() {
        Object $value = this.path.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.path;
            synchronized (atomicReference) {
                $value = this.path.get();
                if ($value == null) {
                    Document.Path actualValue = new Document.Path(this.name);
                    $value = actualValue == null ? this.path : actualValue;
                    this.path.set($value);
                }
            }
        }
        return (Document.Path)($value == this.path ? null : $value);
    }
}

