/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search;

import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.api.Request;
import io.fluxzero.common.api.search.SearchQuery;
import io.fluxzero.common.api.search.SerializedDocument;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

public final class SearchDocuments
extends Request {
    private final SearchQuery query;
    private final List<String> sorting;
    private final Integer maxSize;
    private final List<String> pathFilters;
    private final int skip;
    private final SerializedDocument lastHit;

    public Predicate<Document.Path> computePathFilter() {
        Predicate<Document.Path> excludeFilter = this.pathFilters.stream().filter(p -> p.startsWith("-")).map(path -> {
            path = SearchUtils.normalizePath(path.substring(1));
            Predicate<String> predicate = SearchUtils.getGlobMatcher(path + "/**").or(SearchUtils.getGlobMatcher(path)).negate();
            return Document.Path.isLongPath(path) ? p -> predicate.test(p.getLongValue()) : p -> predicate.test(p.getShortValue());
        }).reduce(Predicate::and).orElse(p -> true);
        Predicate<Document.Path> includeFilter = this.pathFilters.stream().filter(p -> !p.startsWith("-")).map(path -> {
            path = SearchUtils.normalizePath(path);
            Predicate<String> predicate = SearchUtils.getGlobMatcher(path + "/**").or(SearchUtils.getGlobMatcher(path));
            return Document.Path.isLongPath(path) ? p -> predicate.test(p.getLongValue()) : p -> predicate.test(p.getShortValue());
        }).reduce(Predicate::or).orElse(p -> true);
        return includeFilter.and(excludeFilter);
    }

    @Generated
    private static SearchQuery $default$query() {
        return SearchQuery.builder().build();
    }

    @Generated
    private static List<String> $default$sorting() {
        return Collections.emptyList();
    }

    @Generated
    private static List<String> $default$pathFilters() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"query", "sorting", "maxSize", "pathFilters", "skip", "lastHit"})
    @Generated
    SearchDocuments(SearchQuery query, List<String> sorting, Integer maxSize, List<String> pathFilters, int skip, SerializedDocument lastHit) {
        this.query = query;
        this.sorting = sorting;
        this.maxSize = maxSize;
        this.pathFilters = pathFilters;
        this.skip = skip;
        this.lastHit = lastHit;
    }

    @Generated
    public static SearchDocumentsBuilder builder() {
        return new SearchDocumentsBuilder();
    }

    @Generated
    public SearchDocumentsBuilder toBuilder() {
        return new SearchDocumentsBuilder().query(this.query).sorting(this.sorting).maxSize(this.maxSize).pathFilters(this.pathFilters).skip(this.skip).lastHit(this.lastHit);
    }

    @Generated
    public SearchQuery getQuery() {
        return this.query;
    }

    @Generated
    public List<String> getSorting() {
        return this.sorting;
    }

    @Generated
    public Integer getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public List<String> getPathFilters() {
        return this.pathFilters;
    }

    @Generated
    public int getSkip() {
        return this.skip;
    }

    @Generated
    public SerializedDocument getLastHit() {
        return this.lastHit;
    }

    @Generated
    public String toString() {
        return "SearchDocuments(query=" + String.valueOf(this.getQuery()) + ", sorting=" + String.valueOf(this.getSorting()) + ", maxSize=" + this.getMaxSize() + ", pathFilters=" + String.valueOf(this.getPathFilters()) + ", skip=" + this.getSkip() + ", lastHit=" + String.valueOf(this.getLastHit()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDocuments)) {
            return false;
        }
        SearchDocuments other = (SearchDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSkip() != other.getSkip()) {
            return false;
        }
        Integer this$maxSize = this.getMaxSize();
        Integer other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        SearchQuery this$query = this.getQuery();
        SearchQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<String> this$sorting = this.getSorting();
        List<String> other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)this$sorting).equals(other$sorting)) {
            return false;
        }
        List<String> this$pathFilters = this.getPathFilters();
        List<String> other$pathFilters = other.getPathFilters();
        if (this$pathFilters == null ? other$pathFilters != null : !((Object)this$pathFilters).equals(other$pathFilters)) {
            return false;
        }
        SerializedDocument this$lastHit = this.getLastHit();
        SerializedDocument other$lastHit = other.getLastHit();
        return !(this$lastHit == null ? other$lastHit != null : !((Object)this$lastHit).equals(other$lastHit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchDocuments;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSkip();
        Integer $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        SearchQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<String> $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)$sorting).hashCode());
        List<String> $pathFilters = this.getPathFilters();
        result = result * 59 + ($pathFilters == null ? 43 : ((Object)$pathFilters).hashCode());
        SerializedDocument $lastHit = this.getLastHit();
        result = result * 59 + ($lastHit == null ? 43 : ((Object)$lastHit).hashCode());
        return result;
    }

    @Generated
    public static class SearchDocumentsBuilder {
        @Generated
        private boolean query$set;
        @Generated
        private SearchQuery query$value;
        @Generated
        private boolean sorting$set;
        @Generated
        private List<String> sorting$value;
        @Generated
        private Integer maxSize;
        @Generated
        private boolean pathFilters$set;
        @Generated
        private List<String> pathFilters$value;
        @Generated
        private int skip;
        @Generated
        private SerializedDocument lastHit;

        @Generated
        SearchDocumentsBuilder() {
        }

        @Generated
        public SearchDocumentsBuilder query(SearchQuery query) {
            this.query$value = query;
            this.query$set = true;
            return this;
        }

        @Generated
        public SearchDocumentsBuilder sorting(List<String> sorting) {
            this.sorting$value = sorting;
            this.sorting$set = true;
            return this;
        }

        @Generated
        public SearchDocumentsBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        @Generated
        public SearchDocumentsBuilder pathFilters(List<String> pathFilters) {
            this.pathFilters$value = pathFilters;
            this.pathFilters$set = true;
            return this;
        }

        @Generated
        public SearchDocumentsBuilder skip(int skip) {
            this.skip = skip;
            return this;
        }

        @Generated
        public SearchDocumentsBuilder lastHit(SerializedDocument lastHit) {
            this.lastHit = lastHit;
            return this;
        }

        @Generated
        public SearchDocuments build() {
            SearchQuery query$value = this.query$value;
            if (!this.query$set) {
                query$value = SearchDocuments.$default$query();
            }
            List<String> sorting$value = this.sorting$value;
            if (!this.sorting$set) {
                sorting$value = SearchDocuments.$default$sorting();
            }
            List<String> pathFilters$value = this.pathFilters$value;
            if (!this.pathFilters$set) {
                pathFilters$value = SearchDocuments.$default$pathFilters();
            }
            return new SearchDocuments(query$value, sorting$value, this.maxSize, pathFilters$value, this.skip, this.lastHit);
        }

        @Generated
        public String toString() {
            return "SearchDocuments.SearchDocumentsBuilder(query$value=" + String.valueOf(this.query$value) + ", sorting$value=" + String.valueOf(this.sorting$value) + ", maxSize=" + this.maxSize + ", pathFilters$value=" + String.valueOf(this.pathFilters$value) + ", skip=" + this.skip + ", lastHit=" + String.valueOf(this.lastHit) + ")";
        }
    }
}

