/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.tracking;

import io.fluxzero.common.Monitored;
import io.fluxzero.common.api.SerializedMessage;
import io.fluxzero.common.tracking.HasMessageStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface MessageStore
extends AutoCloseable,
Monitored<List<SerializedMessage>>,
HasMessageStore {
    default public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.append(Arrays.asList(messages));
    }

    public CompletableFuture<Void> append(List<SerializedMessage> var1);

    default public List<SerializedMessage> getBatch(Long lastIndex, int maxSize) {
        return this.getBatch(lastIndex, maxSize, false);
    }

    public List<SerializedMessage> getBatch(Long var1, int var2, boolean var3);

    public void setRetentionTime(Duration var1);

    default public <T extends MessageStore> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() {
    }

    @Override
    default public MessageStore getMessageStore() {
        return this;
    }
}

