/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.Registration;
import io.fluxzero.common.ThrowingRunnable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public interface TaskScheduler {
    default public void submit(ThrowingRunnable task) {
        this.schedule(Duration.ZERO, task);
    }

    default public Registration schedule(Duration duration, ThrowingRunnable task) {
        return this.schedule(this.clock().instant().plus(duration), task);
    }

    default public Registration schedule(Instant deadline, ThrowingRunnable task) {
        return this.schedule(deadline.toEpochMilli(), task);
    }

    public Registration schedule(long var1, ThrowingRunnable var3);

    default public <R> CompletableFuture<R> orTimeout(CompletableFuture<R> future, Duration timeout) {
        if (!future.isDone()) {
            Registration r = this.schedule(timeout, () -> future.completeExceptionally(new TimeoutException()));
            future.whenComplete((__, e) -> r.cancel());
        }
        return future;
    }

    public Clock clock();

    public void executeExpiredTasks();

    public void shutdown();
}

