/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.eventsourcing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public final class EventBatch {
    private final String aggregateId;
    private final List<SerializedMessage> events;
    private final boolean storeOnly;

    @JsonIgnore
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.events.size();
    }

    @JsonIgnore
    public long getBytes() {
        return this.events.stream().mapToLong(SerializedMessage::getBytes).sum();
    }

    public String toString() {
        return "EventBatch{aggregateId='" + this.aggregateId + "', event count=" + this.events.size() + ", storeOnly=" + this.storeOnly + "}";
    }

    @JsonIgnore
    public Metric toMetric() {
        return new Metric(this.aggregateId, this.getSize(), this.getBytes(), this.storeOnly);
    }

    @ConstructorProperties(value={"aggregateId", "events", "storeOnly"})
    @Generated
    public EventBatch(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        this.aggregateId = aggregateId;
        this.events = events;
        this.storeOnly = storeOnly;
    }

    @Generated
    public String getAggregateId() {
        return this.aggregateId;
    }

    @Generated
    public List<SerializedMessage> getEvents() {
        return this.events;
    }

    @Generated
    public boolean isStoreOnly() {
        return this.storeOnly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBatch)) {
            return false;
        }
        EventBatch other = (EventBatch)o;
        if (this.isStoreOnly() != other.isStoreOnly()) {
            return false;
        }
        String this$aggregateId = this.getAggregateId();
        String other$aggregateId = other.getAggregateId();
        if (this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId)) {
            return false;
        }
        List<SerializedMessage> this$events = this.getEvents();
        List<SerializedMessage> other$events = other.getEvents();
        return !(this$events == null ? other$events != null : !((Object)this$events).equals(other$events));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStoreOnly() ? 79 : 97);
        String $aggregateId = this.getAggregateId();
        result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
        List<SerializedMessage> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        return result;
    }

    public static final class Metric {
        private final String aggregateId;
        private final int size;
        private final long bytes;
        private final boolean storeOnly;

        @ConstructorProperties(value={"aggregateId", "size", "bytes", "storeOnly"})
        @Generated
        Metric(String aggregateId, int size, long bytes, boolean storeOnly) {
            this.aggregateId = aggregateId;
            this.size = size;
            this.bytes = bytes;
            this.storeOnly = storeOnly;
        }

        @Generated
        public static MetricBuilder builder() {
            return new MetricBuilder();
        }

        @Generated
        public String getAggregateId() {
            return this.aggregateId;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public boolean isStoreOnly() {
            return this.storeOnly;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            if (this.isStoreOnly() != other.isStoreOnly()) {
                return false;
            }
            String this$aggregateId = this.getAggregateId();
            String other$aggregateId = other.getAggregateId();
            return !(this$aggregateId == null ? other$aggregateId != null : !this$aggregateId.equals(other$aggregateId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            result = result * 59 + (this.isStoreOnly() ? 79 : 97);
            String $aggregateId = this.getAggregateId();
            result = result * 59 + ($aggregateId == null ? 43 : $aggregateId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EventBatch.Metric(aggregateId=" + this.getAggregateId() + ", size=" + this.getSize() + ", bytes=" + this.getBytes() + ", storeOnly=" + this.isStoreOnly() + ")";
        }

        @Generated
        public static class MetricBuilder {
            @Generated
            private String aggregateId;
            @Generated
            private int size;
            @Generated
            private long bytes;
            @Generated
            private boolean storeOnly;

            @Generated
            MetricBuilder() {
            }

            @Generated
            public MetricBuilder aggregateId(String aggregateId) {
                this.aggregateId = aggregateId;
                return this;
            }

            @Generated
            public MetricBuilder size(int size) {
                this.size = size;
                return this;
            }

            @Generated
            public MetricBuilder bytes(long bytes) {
                this.bytes = bytes;
                return this;
            }

            @Generated
            public MetricBuilder storeOnly(boolean storeOnly) {
                this.storeOnly = storeOnly;
                return this;
            }

            @Generated
            public Metric build() {
                return new Metric(this.aggregateId, this.size, this.bytes, this.storeOnly);
            }

            @Generated
            public String toString() {
                return "EventBatch.Metric.MetricBuilder(aggregateId=" + this.aggregateId + ", size=" + this.size + ", bytes=" + this.bytes + ", storeOnly=" + this.storeOnly + ")";
            }
        }
    }
}

