/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.reflection;

import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.reflection.ReflectionUtils;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import lombok.Generated;

public abstract class ParameterRegistry {
    private static final Function<Class<?>, ParameterRegistry> registryProvider = ObjectUtils.memoize(type -> {
        String packageName = type.getPackage().getName();
        String simpleClassName = type.getCanonicalName().replace(packageName + ".", "").replace(".", "_") + "_params";
        String fullClassName = packageName + "." + simpleClassName;
        return (ParameterRegistry)ReflectionUtils.asInstance(ReflectionUtils.classForName(fullClassName));
    });
    private final Map<String, List<String>> methodParameters;
    private final Function<Executable, List<String>> parameterExtractor = ObjectUtils.memoize(m -> this.getMethodParameters().get(ParameterRegistry.signature(m)));

    public List<String> getParameterNames(Executable method) {
        List<String> result = this.parameterExtractor.apply(method);
        if (result == null) {
            throw new IllegalStateException("Parameter names for method " + String.valueOf(method) + " not found");
        }
        return result;
    }

    public String getParameterName(Parameter parameter) {
        Executable method = parameter.getDeclaringExecutable();
        List<Parameter> parameters = Arrays.asList(method.getParameters());
        return this.getParameterNames(method).get(parameters.indexOf(parameter));
    }

    public static ParameterRegistry of(Class<?> type) {
        return registryProvider.apply(type);
    }

    public static String signature(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        String parameterTypes = method.getParameters().stream().map(param -> param.asType().toString()).reduce((a, b) -> a + "," + b).orElse("");
        return methodName + "(" + parameterTypes + ")";
    }

    public static String signature(Executable method) {
        return "%s(%s)".formatted(method.getName(), Arrays.stream(method.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.joining(",")));
    }

    @ConstructorProperties(value={"methodParameters"})
    @Generated
    public ParameterRegistry(Map<String, List<String>> methodParameters) {
        this.methodParameters = methodParameters;
    }

    @Generated
    private Map<String, List<String>> getMethodParameters() {
        return this.methodParameters;
    }
}

