/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.DirectExecutorService;
import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.Registration;
import io.fluxzero.common.TaskScheduler;
import io.fluxzero.common.ThrowingRunnable;
import io.fluxzero.common.TimingUtils;
import java.time.Clock;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskScheduler
implements TaskScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskScheduler.class);
    public static int defaultDelay = 100;
    public static Clock defaultclock = Clock.systemUTC();
    public static String defaultThreadName = "InMemoryTaskScheduler";
    private final ScheduledExecutorService executorService;
    private final ExecutorService workerPool;
    private final Clock clock;
    private final Set<Task> tasks = new CopyOnWriteArraySet<Task>();

    public InMemoryTaskScheduler() {
        this(defaultclock);
    }

    public InMemoryTaskScheduler(Clock clock) {
        this(defaultDelay, clock);
    }

    public InMemoryTaskScheduler(String threadName) {
        this(threadName, defaultclock);
    }

    public InMemoryTaskScheduler(String threadName, Clock clock) {
        this(defaultDelay, threadName, clock);
    }

    public InMemoryTaskScheduler(ExecutorService workerPool) {
        this(defaultThreadName, workerPool);
    }

    public InMemoryTaskScheduler(String threadName, ExecutorService workerPool) {
        this(threadName, defaultclock, workerPool);
    }

    public InMemoryTaskScheduler(String threadName, Clock clock, ExecutorService workerPool) {
        this(defaultDelay, threadName, clock, workerPool);
    }

    public InMemoryTaskScheduler(int delay) {
        this(delay, defaultclock);
    }

    public InMemoryTaskScheduler(int delay, Clock clock) {
        this(delay, defaultThreadName, clock);
    }

    public InMemoryTaskScheduler(int delay, String threadName) {
        this(delay, threadName, defaultclock);
    }

    public InMemoryTaskScheduler(int delay, String threadName, Clock clock) {
        this(delay, threadName, clock, DirectExecutorService.newInstance());
    }

    public InMemoryTaskScheduler(int delay, String threadName, Clock clock, ExecutorService workerPool) {
        this.executorService = Executors.newSingleThreadScheduledExecutor(ObjectUtils.newPlatformThreadFactory(threadName));
        this.workerPool = workerPool;
        this.clock = clock;
        this.executorService.scheduleWithFixedDelay(this::executeExpiredTasksAsync, delay, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void executeExpiredTasks() {
        this.tasks.forEach(task -> {
            if (TimingUtils.isMissedDeadline(this.clock(), task.deadline) && this.tasks.remove(task)) {
                this.tryRunTask((Task)task);
            }
        });
    }

    public void executeExpiredTasksAsync() {
        this.tasks.forEach(task -> {
            if (TimingUtils.isMissedDeadline(this.clock(), task.deadline) && this.tasks.remove(task)) {
                this.workerPool.submit(() -> this.tryRunTask((Task)task));
            }
        });
    }

    protected void tryRunTask(Task task) {
        try {
            task.runnable.run();
        }
        catch (Throwable e) {
            log.error("Failed to execute scheduled task", e);
        }
    }

    @Override
    public void submit(ThrowingRunnable task) {
        this.workerPool.submit(ObjectUtils.asRunnable(task));
    }

    @Override
    public Registration schedule(long deadline, ThrowingRunnable task) {
        Task schedulerTask = new Task(task, deadline);
        this.tasks.add(schedulerTask);
        return () -> this.tasks.remove(schedulerTask);
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
        this.workerPool.shutdown();
        if (!this.workerPool.awaitTermination(5L, TimeUnit.SECONDS)) {
            log.warn("Failed to shutdown worker pool before finishing all tasks");
        }
    }

    protected static class Task {
        private final ThrowingRunnable runnable;
        private final long deadline;

        public Task(ThrowingRunnable runnable, long deadline) {
            this.runnable = runnable;
            this.deadline = deadline;
        }
    }
}

