/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.handling;

import io.fluxzero.common.handling.HandlerInvoker;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public interface Handler<M> {
    public Class<?> getTargetClass();

    public Optional<HandlerInvoker> getInvoker(M var1);

    default public Handler<M> or(final Handler<M> next) {
        final Handler first = this;
        return new Handler<M>(this){

            @Override
            public Class<?> getTargetClass() {
                return first.getTargetClass();
            }

            @Override
            public Optional<HandlerInvoker> getInvoker(M message) {
                return first.getInvoker(message).or(() -> next.getInvoker(message));
            }
        };
    }

    public static abstract class DelegatingHandler<M>
    implements Handler<M> {
        protected final Handler<M> delegate;

        @Override
        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        public DelegatingHandler(Handler<M> delegate) {
            this.delegate = delegate;
        }
    }
}

