/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.fluxzero.common.reflection.ReflectionUtils;
import io.fluxzero.common.serialization.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchUtils.class);
    private static final Map<Map.Entry<Class<?>, String>, Boolean> isValidTimestampProperty = new ConcurrentHashMap();
    private static final Pattern dotPattern = Pattern.compile("(?<!\\\\)\\.");
    private static final Map<String, Integer> arrayIndices = IntStream.range(0, 1000).boxed().collect(Collectors.toMap(Object::toString, Function.identity()));
    public static final String letterOrNumber = "\\p{L}0-9";
    public static final Pattern termPattern = Pattern.compile(String.format("\"[^\"]*\"|[%1$s][^\\s]*[%1$s]|[%1$s]", "\\p{L}0-9"), 8);
    private static final Map<String, Predicate<String>> globPatternCache = new ConcurrentHashMap<String, Predicate<String>>();
    public static final DateTimeFormatter ISO_FULL = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant(3).toFormatter();

    public static String normalize(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return StringUtils.stripAccents((String)text).trim().toLowerCase();
    }

    public static byte[] normalizeJson(byte[] data) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (JsonParser p = JsonUtils.writer.createParser(data);
             JsonGenerator generator = JsonUtils.writer.createGenerator((OutputStream)stream, JsonEncoding.UTF8);){
            JsonToken token = p.nextToken();
            while (token != null) {
                if (token == JsonToken.VALUE_STRING) {
                    generator.writeString(SearchUtils.normalize(p.getText()));
                } else {
                    generator.copyCurrentEventExact(p);
                }
                token = p.nextToken();
            }
        }
        return stream.toByteArray();
    }

    public static Predicate<String> getGlobMatcher(String pattern) {
        return globPatternCache.computeIfAbsent(pattern, p -> SearchUtils.tryGetSimpleGlobMatcher(pattern).orElseGet(() -> {
            StringBuilder sb = new StringBuilder(p.length());
            int inGroup = 0;
            int inClass = 0;
            int firstIndexInClass = -1;
            char[] arr = p.toCharArray();
            block16: for (int i = 0; i < arr.length; ++i) {
                char ch = arr[i];
                switch (ch) {
                    case '\\': {
                        if (++i >= arr.length) {
                            sb.append('\\');
                            continue block16;
                        }
                        char next = arr[i];
                        switch (next) {
                            case ',': {
                                break;
                            }
                            case 'E': 
                            case 'Q': {
                                sb.append('\\');
                            }
                            default: {
                                sb.append('\\');
                            }
                        }
                        sb.append(next);
                        continue block16;
                    }
                    case '*': {
                        if (inClass == 0) {
                            sb.append(".*");
                            continue block16;
                        }
                        sb.append('*');
                        continue block16;
                    }
                    case '?': {
                        if (inClass == 0) {
                            sb.append('.');
                            continue block16;
                        }
                        sb.append('?');
                        continue block16;
                    }
                    case '[': {
                        ++inClass;
                        firstIndexInClass = i + 1;
                        sb.append('[');
                        continue block16;
                    }
                    case ']': {
                        --inClass;
                        sb.append(']');
                        continue block16;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                            sb.append('\\');
                        }
                        sb.append(ch);
                        continue block16;
                    }
                    case '!': {
                        if (firstIndexInClass == i) {
                            sb.append('^');
                            continue block16;
                        }
                        sb.append('!');
                        continue block16;
                    }
                    case '{': {
                        ++inGroup;
                        sb.append('(');
                        continue block16;
                    }
                    case '}': {
                        --inGroup;
                        sb.append(')');
                        continue block16;
                    }
                    case ',': {
                        if (inGroup > 0) {
                            sb.append('|');
                            continue block16;
                        }
                        sb.append(',');
                        continue block16;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return Pattern.compile(sb.toString()).asMatchPredicate();
        }));
    }

    private static Optional<Predicate<String>> tryGetSimpleGlobMatcher(String pattern) {
        boolean postfix = pattern.endsWith("**");
        pattern = postfix ? pattern.substring(0, pattern.length() - 2) : pattern;
        boolean prefix = pattern.startsWith("**");
        String finalPattern = prefix ? pattern.substring(2) : pattern;
        for (char globCharacter : "*?{\\".toCharArray()) {
            if (finalPattern.indexOf(globCharacter) < 0) continue;
            return Optional.empty();
        }
        return postfix ? (prefix ? Optional.of(s -> s.contains(finalPattern)) : Optional.of(s -> s.startsWith(finalPattern))) : (prefix ? Optional.of(s -> s.endsWith(finalPattern)) : Optional.of(s -> s.equals(finalPattern)));
    }

    public static boolean isInteger(String fieldName) {
        if (StringUtils.isNumeric((CharSequence)fieldName)) {
            try {
                Integer.parseInt(fieldName);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Object asIntegerOrString(String fieldName) {
        if (StringUtils.isNumeric((CharSequence)fieldName)) {
            Integer result = arrayIndices.get(fieldName);
            if (result != null) {
                return result;
            }
            try {
                return Integer.valueOf(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    public static List<String> splitInTerms(String query) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = termPattern.matcher(query.trim());
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.isEmpty() || group.equals("\"")) continue;
            if (group.startsWith("\"") && group.endsWith("\"")) {
                group = group.substring(1, group.length() - 1);
            }
            parts.add(group);
        }
        return parts;
    }

    public static Object asPrimitive(Object value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value == null) {
            return value;
        }
        return value.toString();
    }

    public static String normalizePath(String queryPath) {
        return queryPath == null ? null : dotPattern.matcher(queryPath).replaceAll("/");
    }

    public static String escapeFieldName(String fieldName) {
        fieldName = ((String)fieldName).replace("/", "\\/");
        if (StringUtils.isNumeric((CharSequence)(fieldName = ((String)fieldName).replace("\"", "\\\"")))) {
            try {
                Integer.valueOf((String)fieldName);
                fieldName = "\"" + (String)fieldName + "\"";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    public static String unescapeFieldName(String fieldName) {
        if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
            fieldName = fieldName.substring(1, fieldName.length() - 1);
        }
        fieldName = fieldName.replace("\\/", "/");
        fieldName = fieldName.replace("\\\"", "\"");
        return fieldName;
    }

    public static Instant parseTimeProperty(String propertyPath, Object object, boolean end, Supplier<Instant> whenMissing) {
        if (object == null || StringUtils.isBlank((CharSequence)propertyPath)) {
            return whenMissing.get();
        }
        Object property = ReflectionUtils.readProperty(propertyPath, object).orElse(null);
        if (property == null) {
            if (isValidTimestampProperty.computeIfAbsent(Map.entry(object.getClass(), propertyPath), key -> {
                if (ReflectionUtils.hasProperty((String)key.getValue(), object)) {
                    return true;
                }
                log.warn("Type {} does not declare a timestamp property '{}'", (Object)((Class)key.getKey()).getSimpleName(), key.getValue());
                return false;
            }).booleanValue()) {
                return null;
            }
            return whenMissing.get();
        }
        Object object2 = property;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalDate.class, LocalDateTime.class, TemporalAccessor.class, String.class}, object3, n)) {
            case 0 -> {
                LocalDate d = (LocalDate)object3;
                yield (end ? d.plusDays(1L) : d).atStartOfDay(ZoneOffset.systemDefault()).toInstant();
            }
            case 1 -> {
                LocalDateTime d = (LocalDateTime)object3;
                yield d.atZone(ZoneOffset.systemDefault()).toInstant();
            }
            case 2 -> {
                TemporalAccessor t = (TemporalAccessor)object3;
                yield Instant.from(t);
            }
            case 3 -> {
                String s = (String)object3;
                yield Instant.parse(s);
            }
            default -> {
                if (isValidTimestampProperty.putIfAbsent(Map.entry(object.getClass(), propertyPath), Boolean.FALSE) == null) {
                    log.warn("Property '{}' of type {} is not a valid timestamp property", (Object)propertyPath, (Object)property.getClass().getSimpleName());
                }
                yield whenMissing.get();
            }
        };
    }
}

