/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common;

import io.fluxzero.common.DefaultMemoizingBiFunction;
import io.fluxzero.common.DefaultMemoizingFunction;
import io.fluxzero.common.DefaultMemoizingSupplier;
import io.fluxzero.common.MemoizingBiFunction;
import io.fluxzero.common.MemoizingFunction;
import io.fluxzero.common.MemoizingSupplier;
import io.fluxzero.common.ThrowingConsumer;
import io.fluxzero.common.ThrowingFunction;
import io.fluxzero.common.ThrowingRunnable;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    private static final Predicate<Object> noOpPredicate = v -> true;
    private static final BiPredicate<Object, Object> noOpBiPredicate = (a, b) -> true;

    public static <T> Predicate<T> noOpPredicate() {
        return noOpPredicate;
    }

    public static <T, U> BiPredicate<T, U> noOpBiPredicate() {
        return noOpBiPredicate;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> Stream<T> iterate(T seed, UnaryOperator<T> f, Predicate<T> breakCondition) {
        return StreamSupport.stream(new BreakingSpliterator<T>(Stream.iterate(seed, f), breakCondition), false);
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        return Arrays.stream(streams).flatMap(Function.identity());
    }

    public static <T> List<T> deduplicate(List<T> list) {
        return ObjectUtils.deduplicate(list, UnaryOperator.identity());
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction) {
        return ObjectUtils.deduplicate(list, idFunction, false);
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction, boolean keepFirst) {
        list = new ArrayList<T>(list);
        HashSet ids = new HashSet();
        if (keepFirst) {
            list.removeIf(t -> !ids.add(idFunction.apply(t)));
        } else {
            ListIterator<T> iterator = list.listIterator(list.size());
            while (iterator.hasPrevious()) {
                if (ids.add(idFunction.apply(iterator.previous()))) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public static Stream<?> asStream(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, Stream.class, Optional.class}, (Object)object, n)) {
            case -1 -> Stream.empty();
            case 0 -> {
                Collection objects = (Collection)object;
                yield objects.stream();
            }
            case 1 -> {
                Stream stream;
                yield stream = (Stream)object;
            }
            case 2 -> {
                Optional o = (Optional)object;
                yield o.stream();
            }
            default -> Stream.of(value);
        };
    }

    public static Consumer<Runnable> ifTrue(boolean check) {
        return check ? Runnable::run : r -> {};
    }

    public static Object forceThrow(Throwable error) {
        throw error;
    }

    public static <T> T call(Callable<T> callable) {
        return callable.call();
    }

    public static void run(ThrowingRunnable runnable) {
        runnable.run();
    }

    public static Callable<?> asCallable(ThrowingRunnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    public static Callable<?> asCallable(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    public static void tryRun(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            log.error("Task {} failed", (Object)task, (Object)e);
        }
    }

    public static Runnable tryCatch(Runnable runnable) {
        return () -> ObjectUtils.tryRun(runnable);
    }

    public static <T> Supplier<T> asSupplier(Callable<T> callable) {
        return () -> ObjectUtils.call(callable);
    }

    public static Runnable asRunnable(ThrowingRunnable runnable) {
        return () -> ObjectUtils.run(runnable);
    }

    public static <T, R> Function<T, R> asFunction(ThrowingFunction<T, R> function) {
        return t -> ObjectUtils.call(() -> function.apply(t));
    }

    public static <T> Consumer<T> asConsumer(ThrowingConsumer<T> consumer) {
        return t -> ObjectUtils.run(() -> consumer.accept(t));
    }

    public static Runnable asRunnable(Callable<?> callable) {
        return () -> ObjectUtils.call(callable);
    }

    public static byte[] getBytes(ByteBuffer buffer) {
        buffer = buffer.duplicate();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public static Throwable unwrapException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CompletionException || e instanceof ExecutionException) {
            return ObjectUtils.unwrapException(e.getCause());
        }
        return e;
    }

    public static Properties asProperties(String content) {
        Properties result = new Properties();
        result.load(new StringReader(content));
        return result;
    }

    public static Properties copyOf(Properties properties) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    public static Properties merge(Properties a, Properties b) {
        Properties result = ObjectUtils.copyOf(a);
        result.putAll((Map<?, ?>)b);
        return result;
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier) {
        MemoizingSupplier<T> memoizingSupplier;
        if (supplier instanceof MemoizingSupplier) {
            MemoizingSupplier existing = (MemoizingSupplier)supplier;
            memoizingSupplier = existing;
        } else {
            memoizingSupplier = new DefaultMemoizingSupplier<T>(supplier);
        }
        return memoizingSupplier;
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier) {
        MemoizingFunction<K, V> memoizingFunction;
        if (supplier instanceof MemoizingFunction) {
            MemoizingFunction existing = (MemoizingFunction)supplier;
            memoizingFunction = existing;
        } else {
            memoizingFunction = new DefaultMemoizingFunction<K, V>(supplier);
        }
        return memoizingFunction;
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier) {
        MemoizingBiFunction<T, U, R> memoizingBiFunction;
        if (supplier instanceof MemoizingBiFunction) {
            MemoizingBiFunction existing = (MemoizingBiFunction)supplier;
            memoizingBiFunction = existing;
        } else {
            memoizingBiFunction = new DefaultMemoizingBiFunction<T, U, R>(supplier);
        }
        return memoizingBiFunction;
    }

    public static ThreadFactory newPlatformThreadFactory(String prefix) {
        return Thread.ofPlatform().name(prefix, 0L).factory();
    }

    public static ThreadFactory newVirtualThreadFactory(String prefix) {
        return Thread.ofVirtual().name(prefix, 0L).factory();
    }

    public static <T> Consumer<? super T> tryAccept(Consumer<? super T> consumer) {
        return t -> ObjectUtils.tryRun(() -> consumer.accept(t));
    }

    public static byte[] join(byte[] ... chunks) {
        byte[] byArray;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (byte[] i : chunks) {
                outputStream.write(i);
            }
            byArray = outputStream.toByteArray();
        }
        return byArray;
    }

    private static class BreakingSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Iterator<T> delegate;
        private final Predicate<T> breakCondition;
        private boolean stopped;

        private BreakingSpliterator(Stream<T> delegate, Predicate<T> breakCondition) {
            super(Long.MAX_VALUE, 0);
            this.delegate = delegate.iterator();
            this.breakCondition = breakCondition;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.stopped) {
                return false;
            }
            T value = this.delegate.next();
            if (this.breakCondition.test(value)) {
                this.stopped = true;
            }
            action.accept(value);
            return true;
        }
    }

    private static class PrefixedThreadFactory
    implements ThreadFactory {
        private static final Map<String, AtomicInteger> poolCount = new ConcurrentHashMap<String, AtomicInteger>();
        private final ThreadGroup group = Thread.currentThread().getThreadGroup();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public PrefixedThreadFactory(String poolPrefix) {
            this.namePrefix = poolPrefix + "-pool-" + poolCount.computeIfAbsent(poolPrefix, k -> new AtomicInteger(1)).getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread t = new Thread(this.group, task, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

