/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.Guarantee;
import io.fluxzero.common.api.Command;
import io.fluxzero.common.api.search.SerializedDocument;
import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class IndexDocuments
extends Command {
    private final List<SerializedDocument> documents;
    private final boolean ifNotExists;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.documents.size();
    }

    @JsonIgnore
    long getBytes() {
        return this.documents.stream().mapToLong(SerializedDocument::bytes).sum();
    }

    @JsonIgnore
    Set<String> getCollections() {
        return this.documents.stream().map(SerializedDocument::getCollection).collect(Collectors.toSet());
    }

    @JsonIgnore
    Set<String> getIds() {
        return this.documents.stream().map(SerializedDocument::getId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String toString() {
        return "IndexDocuments of length " + this.documents.size();
    }

    @Override
    public Metric toMetric() {
        return new Metric(this.getSize(), this.ifNotExists, this.guarantee, this.getCollections(), this.getIds(), this.getBytes());
    }

    @Override
    public String routingKey() {
        return this.documents.stream().findFirst().map(SerializedDocument::getId).orElse(null);
    }

    @ConstructorProperties(value={"documents", "ifNotExists", "guarantee"})
    @Generated
    public IndexDocuments(List<SerializedDocument> documents, boolean ifNotExists, Guarantee guarantee) {
        this.documents = documents;
        this.ifNotExists = ifNotExists;
        this.guarantee = guarantee;
    }

    @Generated
    public List<SerializedDocument> getDocuments() {
        return this.documents;
    }

    @Generated
    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Generated
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDocuments)) {
            return false;
        }
        IndexDocuments other = (IndexDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        List<SerializedDocument> this$documents = this.getDocuments();
        List<SerializedDocument> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexDocuments;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        List<SerializedDocument> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public static final class Metric {
        private final int size;
        private final boolean ifNotExists;
        private final Guarantee guarantee;
        private final Set<String> collections;
        private final Set<String> ids;
        private final long bytes;

        @ConstructorProperties(value={"size", "ifNotExists", "guarantee", "collections", "ids", "bytes"})
        @Generated
        public Metric(int size, boolean ifNotExists, Guarantee guarantee, Set<String> collections, Set<String> ids, long bytes) {
            this.size = size;
            this.ifNotExists = ifNotExists;
            this.guarantee = guarantee;
            this.collections = collections;
            this.ids = ids;
            this.bytes = bytes;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public boolean isIfNotExists() {
            return this.ifNotExists;
        }

        @Generated
        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        @Generated
        public Set<String> getCollections() {
            return this.collections;
        }

        @Generated
        public Set<String> getIds() {
            return this.ids;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.isIfNotExists() != other.isIfNotExists()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            if (this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee)) {
                return false;
            }
            Set<String> this$collections = this.getCollections();
            Set<String> other$collections = other.getCollections();
            if (this$collections == null ? other$collections != null : !((Object)this$collections).equals(other$collections)) {
                return false;
            }
            Set<String> this$ids = this.getIds();
            Set<String> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            result = result * 59 + (this.isIfNotExists() ? 79 : 97);
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            Guarantee $guarantee = this.getGuarantee();
            result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            Set<String> $collections = this.getCollections();
            result = result * 59 + ($collections == null ? 43 : ((Object)$collections).hashCode());
            Set<String> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IndexDocuments.Metric(size=" + this.getSize() + ", ifNotExists=" + this.isIfNotExists() + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ", collections=" + String.valueOf(this.getCollections()) + ", ids=" + String.valueOf(this.getIds()) + ", bytes=" + this.getBytes() + ")";
        }
    }
}

