/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.search;

import io.fluxzero.common.api.Data;
import io.fluxzero.common.search.Document;
import io.fluxzero.common.serialization.compression.CompressionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public enum DefaultDocumentSerializer {
    INSTANCE;

    private static final int currentVersion = 0;

    public Data<byte[]> serialize(Document document) {
        Data<byte[]> data;
        block10: {
            MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
            try {
                Map<Document.Entry, List<Document.Path>> map = document.getEntries();
                packer.packInt(0).packString(document.getId());
                DefaultDocumentSerializer.packTimestamp(document.getTimestamp(), (MessagePacker)packer);
                DefaultDocumentSerializer.packTimestamp(document.getEnd(), (MessagePacker)packer);
                packer.packString(document.getCollection()).packArrayHeader(map.size());
                for (Map.Entry<Document.Entry, List<Document.Path>> e : map.entrySet()) {
                    packer.packByte(e.getKey().getType().serialize());
                    packer.packString(e.getKey().getValue());
                    List<Document.Path> keys = e.getValue();
                    packer.packArrayHeader(keys.size());
                    for (Document.Path key : keys) {
                        packer.packString(key.getValue());
                    }
                }
                data = new Data<byte[]>(CompressionUtils.compress(packer.toByteArray()), document.getType(), document.getRevision(), "document");
                if (packer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (packer != null) {
                        try {
                            packer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not serialize document", e);
                }
            }
            packer.close();
        }
        return data;
    }

    public Document deserialize(Data<byte[]> document) {
        Document document2;
        block12: {
            if (!this.canDeserialize(document)) {
                throw new IllegalArgumentException("Unsupported data format: " + document.getFormat());
            }
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])CompressionUtils.decompress(document.getValue()));
            try {
                int version = unpacker.unpackInt();
                if (version != 0) {
                    throw new IllegalArgumentException("Unsupported document revision: " + version);
                }
                String id = unpacker.unpackString();
                Instant timestamp = DefaultDocumentSerializer.unpackTimestamp(unpacker);
                Instant end = DefaultDocumentSerializer.unpackTimestamp(unpacker);
                String collection = unpacker.unpackString();
                LinkedHashMap<Document.Entry, List<Document.Path>> map = new LinkedHashMap<Document.Entry, List<Document.Path>>();
                int size = unpacker.unpackArrayHeader();
                for (int i = 0; i < size; ++i) {
                    Document.Entry value = new Document.Entry(Document.EntryType.deserialize(unpacker.unpackByte()), unpacker.unpackString());
                    int keysCount = unpacker.unpackArrayHeader();
                    ArrayList<Document.Path> keys = new ArrayList<Document.Path>(keysCount);
                    map.put(value, keys);
                    for (int j = 0; j < keysCount; ++j) {
                        keys.add(new Document.Path(unpacker.unpackString()));
                    }
                }
                document2 = new Document(id, document.getType(), document.getRevision(), collection, timestamp, end, map, null, Collections.emptySet(), Collections.emptySet());
                if (unpacker == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (unpacker != null) {
                        try {
                            unpacker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not deserialize document", e);
                }
            }
            unpacker.close();
        }
        return document2;
    }

    public boolean canDeserialize(Data<byte[]> data) {
        return "document".equals(data.getFormat());
    }

    private static void packTimestamp(Instant value, MessagePacker packer) {
        if (value == null) {
            packer.packNil();
        } else {
            packer.packLong(value.toEpochMilli());
        }
    }

    private static Instant unpackTimestamp(MessageUnpacker unpacker) {
        if (unpacker.getNextFormat().getValueType().isNilType()) {
            unpacker.unpackNil();
            return null;
        }
        return Instant.ofEpochMilli(unpacker.unpackLong());
    }

    private static Long unpackLong(MessageUnpacker unpacker) {
        if (unpacker.getNextFormat().getValueType().isNilType()) {
            unpacker.unpackNil();
            return null;
        }
        return unpacker.unpackLong();
    }
}

