/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.search.constraints;

import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.api.HasId;
import io.fluxzero.common.api.search.Constraint;
import io.fluxzero.common.api.search.FacetEntry;
import io.fluxzero.common.api.search.NoOpConstraint;
import io.fluxzero.common.api.search.constraints.AnyConstraint;
import io.fluxzero.common.search.Document;
import java.beans.ConstructorProperties;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class FacetConstraint
implements Constraint {
    @NonNull
    private final FacetEntry facet;

    public static Constraint matchFacet(String name, Object value) {
        if (name == null) {
            return NoOpConstraint.instance;
        }
        String normalizedName = SearchUtils.normalizePath(name);
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class, HasId.class}, (Object)object, n)) {
            case 0: {
                Collection objects = (Collection)object;
                List<Constraint> constraints = objects.stream().filter(Objects::nonNull).map(v -> new FacetConstraint(new FacetEntry(normalizedName, v.toString()))).collect(Collectors.toList());
                return switch (constraints.size()) {
                    case 0 -> NoOpConstraint.instance;
                    case 1 -> (Constraint)constraints.getFirst();
                    default -> AnyConstraint.any(constraints);
                };
            }
            case 1: {
                HasId id = (HasId)object;
                return new FacetConstraint(new FacetEntry(normalizedName, id.getId()));
            }
            case -1: {
                return NoOpConstraint.instance;
            }
        }
        return new FacetConstraint(new FacetEntry(normalizedName, value.toString()));
    }

    public static Constraint matchFacet(FacetEntry facet) {
        return facet == null ? NoOpConstraint.instance : new FacetConstraint(facet);
    }

    @Override
    public boolean matches(Document document) {
        return document.getFacets().contains(this.facet);
    }

    @Override
    public boolean hasPathConstraint() {
        return false;
    }

    @NonNull
    @Generated
    public FacetEntry getFacet() {
        return this.facet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacetConstraint)) {
            return false;
        }
        FacetConstraint other = (FacetConstraint)o;
        FacetEntry this$facet = this.getFacet();
        FacetEntry other$facet = other.getFacet();
        return !(this$facet == null ? other$facet != null : !((Object)this$facet).equals(other$facet));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FacetEntry $facet = this.getFacet();
        result = result * 59 + ($facet == null ? 43 : ((Object)$facet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FacetConstraint(facet=" + String.valueOf(this.getFacet()) + ")";
    }

    @ConstructorProperties(value={"facet"})
    @Generated
    private FacetConstraint(@NonNull FacetEntry facet) {
        if (facet == null) {
            throw new NullPointerException("facet is marked non-null but is null");
        }
        this.facet = facet;
    }
}

